/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.model;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartMultiplicity;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class PartClassifierInstance
implements ClassifierInstance {
    private final Property part;
    private final Classifier classifier;
    private final InstanceSpecification instance;
    private final InstanceSpecification compositeInstance;
    private final List<PartMultiplicity> containers;

    public PartClassifierInstance(Property part, Classifier classifier, InstanceSpecification instance, InstanceSpecification compositeInstance, List<PartMultiplicity> containers) {
        this.part = part;
        this.classifier = classifier;
        this.instance = instance;
        this.compositeInstance = compositeInstance;
        this.containers = containers;
    }

    @Override
    public String getName() {
        return this.part.getName();
    }

    @Override
    public String getActualName() {
        return UmlSerializerExtensions.actualName((EObject)this.part);
    }

    @Override
    public String getInstQualifiedName() {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.compositeInstance.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_");
        Functions.Function1 _function = it -> {
            boolean _equals;
            String _xifexpression = null;
            Property _part = it.getPart();
            int _lower = _part.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                Property _part_1 = it.getPart();
                _xifexpression = _part_1.getName();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                Property _part_2 = it.getPart();
                String _name_1 = _part_2.getName();
                _builder_1.append((Object)_name_1, "");
                int _multiplicityId = it.getMultiplicityId();
                _builder_1.append((Object)_multiplicityId, "");
                _xifexpression = _builder_1.toString();
            }
            return _xifexpression;
        };
        List _map = ListExtensions.map(this.containers, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"_");
        _builder.append((Object)_join, "");
        return _builder.toString();
    }

    @Override
    public int getLower() {
        return this.part.getLower();
    }

    @Override
    public int getMultiplicityId() {
        PartMultiplicity _last = (PartMultiplicity)IterableExtensions.last(this.containers);
        return _last.getMultiplicityId();
    }

    @Override
    public List<PartMultiplicity> getContainers() {
        return this.containers;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.compositeInstance == null ? 0 : this.compositeInstance.hashCode());
        result = 31 * result + (this.containers == null ? 0 : this.containers.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartClassifierInstance other = (PartClassifierInstance)obj;
        if (this.part == null ? other.part != null : !this.part.equals(other.part)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        if (this.compositeInstance == null ? other.compositeInstance != null : !this.compositeInstance.equals(other.compositeInstance)) {
            return false;
        }
        return !(this.containers == null ? other.containers != null : !this.containers.equals(other.containers));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("part", (Object)this.part);
        b.add("classifier", (Object)this.classifier);
        b.add("instance", (Object)this.instance);
        b.add("compositeInstance", (Object)this.compositeInstance);
        b.add("containers", this.containers);
        return b.toString();
    }

    @Pure
    public Property getPart() {
        return this.part;
    }

    @Override
    @Pure
    public Classifier getClassifier() {
        return this.classifier;
    }

    @Override
    @Pure
    public InstanceSpecification getInstance() {
        return this.instance;
    }

    @Pure
    public InstanceSpecification getCompositeInstance() {
        return this.compositeInstance;
    }
}

