/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.base.Objects;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.model.ResourceManager;
import emi.serializer.serialization.propertyserializer.DefaultPropertySerializer;
import emi.serializer.serialization.propertyserializer.FunctionPropertySerializer;
import emi.serializer.serialization.propertyserializer.IndexPropertySerializer;
import emi.serializer.serialization.propertyserializer.InlinePropertySerializer;
import emi.serializer.serialization.propertyserializer.KindPropertySerializer;
import emi.serializer.serialization.propertyserializer.OnlyInlinePropertySerializer;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.serialization.uml.UmlSubset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class MetamodelTable {
    private final UmlSubset umlSubset;
    private final Map<EClassifier, Metaclass> metaclasses;
    private final Map<EClassifier, Set<Pair<EClass, EClass>>> multipleInheritances;

    public MetamodelTable(ResourceManager rm) {
        UmlSubset _umlSubset;
        this.umlSubset = _umlSubset = new UmlSubset(rm);
        HashMap<EClassifier, Metaclass> _hashMap = new HashMap<EClassifier, Metaclass>();
        this.metaclasses = _hashMap;
        HashMap<EClassifier, Set<Pair<EClass, EClass>>> _hashMap_1 = new HashMap<EClassifier, Set<Pair<EClass, EClass>>>();
        this.multipleInheritances = _hashMap_1;
    }

    public void generate() {
        Map<EClass, List<? extends PropertySerializer>> _propertiesByClass = this.umlSubset.getPropertiesByClass();
        Set<Map.Entry<EClass, List<? extends PropertySerializer>>> _entrySet = _propertiesByClass.entrySet();
        this.generateMetaclasses(_entrySet);
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet_1 = this.metaclasses.entrySet();
        Consumer<Map.Entry> _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            EClassifier _key = (EClassifier)it.getKey();
            String _name = _key.getName();
            _builder.append((Object)_name, "");
            InputOutput.println((Object)_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"    ");
            _builder_1.append((Object)"attributes -> [");
            Metaclass _value = (Metaclass)it.getValue();
            Map<String, PropertySerializer> _attributes = _value.getAttributes();
            Set<Map.Entry<String, PropertySerializer>> _entrySet_2 = _attributes.entrySet();
            Functions.Function1 _function_1 = it_1 -> (String)it_1.getKey();
            Iterable _map = IterableExtensions.map(_entrySet_2, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder_1.append((Object)_join, "    ");
            _builder_1.append((Object)"]");
            InputOutput.println((Object)_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"    ");
            _builder_2.append((Object)"superclasses -> [");
            Metaclass _value_1 = (Metaclass)it.getValue();
            Set<EClass> _superclasses = _value_1.getSuperclasses();
            Functions.Function1 _function_2 = it_1 -> it_1.getName();
            Iterable _map_1 = IterableExtensions.map(_superclasses, (Functions.Function1)_function_2);
            String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)", ");
            _builder_2.append((Object)_join_1, "    ");
            _builder_2.append((Object)"]");
            InputOutput.println((Object)_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)"    ");
            _builder_3.append((Object)"properties -> ");
            Metaclass _value_2 = (Metaclass)it.getValue();
            List<PropertySerializer> _properties = _value_2.getProperties();
            _builder_3.append(_properties, "    ");
            InputOutput.println((Object)_builder_3.toString());
        };
        _entrySet_1.forEach(_function);
        InputOutput.println((Object)"\n");
        this.checkTypes();
        InputOutput.println((Object)"\n");
        this.checkMultipleInheritances();
        this.displayMultipleInheritances(this.multipleInheritances);
        this.sortSuperclasses();
        this.computeAllAttributesSerializer();
    }

    public void generateMetaclasses(Set<Map.Entry<EClass, List<? extends PropertySerializer>>> properties) {
        Consumer<Map.Entry> _function = it -> {
            EClass eClass = (EClass)it.getKey();
            List _value = (List)it.getValue();
            Consumer<PropertySerializer> _function_1 = it_1 -> {
                if (it_1 instanceof DefaultPropertySerializer) {
                    String _propertyName = ((DefaultPropertySerializer)it_1).getPropertyName();
                    this.computeAttributeSymbol(eClass, _propertyName, (PropertySerializer)it_1);
                } else if (it_1 instanceof InlinePropertySerializer) {
                    String _propertyName_1 = ((InlinePropertySerializer)it_1).getPropertyName();
                    this.computeAttributeSymbol(eClass, _propertyName_1, (PropertySerializer)it_1);
                } else {
                    Metaclass thisMetaclass = this.metaclasses.get(eClass);
                    if (thisMetaclass == null) {
                        Metaclass _metaclass;
                        thisMetaclass = _metaclass = new Metaclass();
                    }
                    if (it_1 instanceof OnlyInlinePropertySerializer) {
                        thisMetaclass.setOnlyInline(true);
                    } else {
                        List<PropertySerializer> _properties = thisMetaclass.getProperties();
                        _properties.add((PropertySerializer)it_1);
                    }
                    this.metaclasses.put((EClassifier)eClass, thisMetaclass);
                }
            };
            _value.forEach(_function_1);
        };
        properties.forEach(_function);
    }

    public void computeAttributeSymbol(EClass eClass, String attributeName, PropertySerializer serializer) {
        EStructuralFeature feature = eClass.getEStructuralFeature(attributeName);
        if (feature != null) {
            boolean _notEquals;
            Metaclass thisMetaclass;
            Metaclass typeMetaclass;
            EClassifier _eType;
            EClassifier _type;
            EClass container = feature.getEContainingClass();
            EClassifier featureType = null;
            featureType = serializer instanceof DefaultPropertySerializer ? (_type = ((DefaultPropertySerializer)serializer).getType(feature)) : (_eType = feature.getEType());
            Metaclass attributeMetaclass = this.metaclasses.get(container);
            if (attributeMetaclass == null) {
                Metaclass _metaclass;
                attributeMetaclass = _metaclass = new Metaclass();
            }
            if ((typeMetaclass = this.metaclasses.get(featureType)) == null) {
                Metaclass _metaclass_1;
                typeMetaclass = _metaclass_1 = new Metaclass();
                this.metaclasses.put(featureType, typeMetaclass);
            }
            if ((thisMetaclass = this.metaclasses.get(eClass)) == null) {
                Metaclass _metaclass_2;
                thisMetaclass = _metaclass_2 = new Metaclass();
            }
            Map<String, PropertySerializer> _attributes = attributeMetaclass.getAttributes();
            _attributes.put(attributeName, serializer);
            boolean bl = _notEquals = !Objects.equal((Object)attributeMetaclass, (Object)thisMetaclass);
            if (_notEquals) {
                Set<EClass> _superclasses = thisMetaclass.getSuperclasses();
                _superclasses.add(container);
                this.metaclasses.put((EClassifier)eClass, thisMetaclass);
                this.metaclasses.put((EClassifier)container, attributeMetaclass);
            } else {
                this.metaclasses.put((EClassifier)container, attributeMetaclass);
            }
        } else {
            InputOutput.println((Object)(attributeName + " -> not found"));
        }
    }

    public void checkTypes() {
        HashMap<EClass, List<? extends PropertySerializer>> properties = new HashMap<EClass, List<? extends PropertySerializer>>();
        Map<EClass, List<? extends PropertySerializer>> _propertiesByClass = this.umlSubset.getPropertiesByClass();
        properties.putAll(_propertiesByClass);
        HashMap<EClassifier, Set<Pair<String, EClass>>> unfoundTypes = new HashMap<EClassifier, Set<Pair<String, EClass>>>();
        Set _entrySet = properties.entrySet();
        Consumer<Map.Entry> _function = it -> {
            EClass eClass = (EClass)it.getKey();
            List _value = (List)it.getValue();
            Consumer<PropertySerializer> _function_1 = it_1 -> {
                if (it_1 instanceof DefaultPropertySerializer) {
                    String _propertyName = ((DefaultPropertySerializer)it_1).getPropertyName();
                    EClassifier _simplifiedPropertyType = ((DefaultPropertySerializer)it_1).getSimplifiedPropertyType();
                    this.checkPropertyType(eClass, _propertyName, _simplifiedPropertyType, properties, unfoundTypes);
                } else if (it_1 instanceof InlinePropertySerializer) {
                    String _propertyName_1 = ((InlinePropertySerializer)it_1).getPropertyName();
                    this.checkPropertyType(eClass, _propertyName_1, null, properties, unfoundTypes);
                }
            };
            _value.forEach(_function_1);
        };
        _entrySet.forEach(_function);
        this.displayUnfoundTypes(unfoundTypes);
    }

    private void checkPropertyType(EClass eClass, String propertyName, EClassifier simplifiedPropertyType, Map<EClass, List<? extends PropertySerializer>> properties, Map<EClassifier, Set<Pair<String, EClass>>> unfoundTypes) {
        EClassifier type = null;
        if (simplifiedPropertyType != null) {
            type = simplifiedPropertyType;
        } else {
            EClassifier _eType;
            EStructuralFeature _eStructuralFeature = eClass.getEStructuralFeature(propertyName);
            type = _eType = _eStructuralFeature.getEType();
        }
        if ((type instanceof EClass || type instanceof EEnum) && properties.get(type) == null) {
            Pair pair = new Pair((Object)propertyName, (Object)eClass);
            Set<Pair<String, EClass>> list = unfoundTypes.get(type);
            if (list == null) {
                HashSet<Pair<String, EClass>> _hashSet = new HashSet<Pair<String, EClass>>();
                list = _hashSet;
            }
            list.add((Pair<String, EClass>)pair);
            unfoundTypes.put(type, list);
        }
    }

    private void displayUnfoundTypes(Map<EClassifier, Set<Pair<String, EClass>>> unfoundTypes) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"List of unfound types (automatically added in the metamodel serialization):");
        _builder.newLine();
        Set<Map.Entry<EClassifier, Set<Pair<String, EClass>>>> _entrySet = unfoundTypes.entrySet();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"[");
            EClassifier _key = (EClassifier)it.getKey();
            String _name = _key.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"]:");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            Set _value = (Set)it.getValue();
            Functions.Function1 _function_1 = it_1 -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"attribute \"");
                String _key_1 = (String)it_1.getKey();
                _builder_2.append((Object)_key_1, "");
                _builder_2.append((Object)"\" of class \"");
                EClass _value_1 = (EClass)it_1.getValue();
                String _name_1 = _value_1.getName();
                _builder_2.append((Object)_name_1, "");
                _builder_2.append((Object)"\"");
                return _builder_2.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)_value, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
            _builder_1.append((Object)_join, "\t");
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        String string = _builder.toString();
        InputOutput.println((Object)string);
    }

    public void checkMultipleInheritances() {
        boolean _equals;
        int _size = this.metaclasses.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            this.generate();
        }
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = this.metaclasses.entrySet();
        Consumer<Map.Entry> _function = it -> {
            Map.Entry metaclass = it;
            Metaclass _value = (Metaclass)it.getValue();
            Set<EClass> superclasses = _value.getSuperclasses();
            Metaclass _value_1 = (Metaclass)it.getValue();
            Set<EClass> _superclasses = _value_1.getSuperclasses();
            Consumer<EClass> _function_1 = it_1 -> {
                EClass superclass = it_1;
                Consumer<EClass> _function_2 = it_2 -> {
                    if (!(Objects.equal((Object)it_2, (Object)superclass) || it_2.getEAllSuperTypes().contains((Object)superclass) || superclass.getEAllSuperTypes().contains(it_2))) {
                        EClassifier _key = (EClassifier)metaclass.getKey();
                        Set<Pair<EClass, EClass>> list = this.multipleInheritances.get(_key);
                        if (list == null) {
                            HashSet<Pair<EClass, EClass>> _hashSet = new HashSet<Pair<EClass, EClass>>();
                            list = _hashSet;
                        }
                        if (!list.contains(new Pair((Object)superclass, it_2)) && !list.contains(new Pair(it_2, (Object)superclass))) {
                            Pair _pair = new Pair((Object)superclass, it_2);
                            list.add((Pair<EClass, EClass>)_pair);
                            EClassifier _key_1 = (EClassifier)metaclass.getKey();
                            this.multipleInheritances.put(_key_1, list);
                        }
                    }
                };
                superclasses.forEach(_function_2);
            };
            _superclasses.forEach(_function_1);
        };
        _entrySet.forEach(_function);
    }

    private void displayMultipleInheritances(Map<EClassifier, Set<Pair<EClass, EClass>>> inheritances) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"List of multiple inheritance conflicts:");
        _builder.newLine();
        Set<Map.Entry<EClassifier, Set<Pair<EClass, EClass>>>> _entrySet = inheritances.entrySet();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"[");
            EClassifier _key = (EClassifier)it.getKey();
            String _name = _key.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"]:");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            Set _value = (Set)it.getValue();
            Functions.Function1 _function_1 = it_1 -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"inherits from both \"");
                EClass _key_1 = (EClass)it_1.getKey();
                String _name_1 = _key_1.getName();
                _builder_2.append((Object)_name_1, "");
                _builder_2.append((Object)"\" and \"");
                EClass _value_1 = (EClass)it_1.getValue();
                String _name_2 = _value_1.getName();
                _builder_2.append((Object)_name_2, "");
                _builder_2.append((Object)"\"");
                return _builder_2.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)_value, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
            _builder_1.append((Object)_join, "\t");
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        String string = _builder.toString();
        InputOutput.println((Object)string);
    }

    public Map<EClassifier, Metaclass> getMetaclasses() {
        return this.metaclasses;
    }

    public void sortSuperclasses() {
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = this.metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Consumer<Map.Entry> _function_1 = it -> {
            boolean _tripleEquals;
            EClassifier _key = (EClassifier)it.getKey();
            Set<Pair<EClass, EClass>> _get = this.multipleInheritances.get(_key);
            boolean bl = _tripleEquals = _get == null;
            if (_tripleEquals) {
                Metaclass _value = (Metaclass)it.getValue();
                _value.setHasMultipleInheritances(false);
                Metaclass _value_1 = (Metaclass)it.getValue();
                _value_1.sortSuperclasses();
            } else {
                Metaclass _value_2 = (Metaclass)it.getValue();
                _value_2.setHasMultipleInheritances(true);
            }
        };
        classes.forEach(_function_1);
    }

    public List<String> getAllAttributesNames(Metaclass metaclass) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> list = new ArrayList<String>();
        Set<EClass> _superclasses = metaclass.getSuperclasses();
        Consumer<EClass> _function = it -> {
            Metaclass superMetaclass = this.metaclasses.get(it);
            List<String> _attributesNames = this.getAttributesNames(superMetaclass);
            list.addAll(_attributesNames);
        };
        _superclasses.forEach(_function);
        List<String> _attributesNames = this.getAttributesNames(metaclass);
        list.addAll(_attributesNames);
        _xblockexpression = list;
        return _xblockexpression;
    }

    public List<String> getAttributesNames(Metaclass metaclass) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> list = new ArrayList<String>();
        List<PropertySerializer> _properties = metaclass.getProperties();
        Consumer<PropertySerializer> _function = it -> {
            if (it instanceof KindPropertySerializer) {
                list.add("c_kind");
            } else if (it instanceof IndexPropertySerializer) {
                list.add("c_index");
            } else if (it instanceof FunctionPropertySerializer) {
                list.add("c_function");
            }
        };
        _properties.forEach(_function);
        Map<String, PropertySerializer> _attributes = metaclass.getAttributes();
        Set<Map.Entry<String, PropertySerializer>> _entrySet = _attributes.entrySet();
        Consumer<Map.Entry> _function_1 = it -> {
            String _key = (String)it.getKey();
            list.add(_key);
        };
        _entrySet.forEach(_function_1);
        _xblockexpression = list;
        return _xblockexpression;
    }

    public void computeAllAttributesSerializer() {
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = this.metaclasses.entrySet();
        Consumer<Map.Entry> _function = it -> {
            Metaclass _value = (Metaclass)it.getValue();
            List<PropertySerializer> _allAttributes = _value.getAllAttributes();
            Metaclass _value_1 = (Metaclass)it.getValue();
            List<PropertySerializer> _allAttributesSerializer = this.getAllAttributesSerializer(_value_1);
            _allAttributes.addAll(_allAttributesSerializer);
        };
        _entrySet.forEach(_function);
    }

    public List<PropertySerializer> getAllAttributesSerializer(Metaclass metaclass) {
        ArrayList<PropertySerializer> _xblockexpression = null;
        ArrayList<PropertySerializer> list = new ArrayList<PropertySerializer>();
        Set<EClass> _superclasses = metaclass.getSuperclasses();
        Consumer<EClass> _function = it -> {
            Metaclass superMetaclass = this.metaclasses.get(it);
            List<PropertySerializer> _attributesSerializer = this.getAttributesSerializer(superMetaclass);
            list.addAll(_attributesSerializer);
        };
        _superclasses.forEach(_function);
        List<PropertySerializer> _attributesSerializer = this.getAttributesSerializer(metaclass);
        list.addAll(_attributesSerializer);
        _xblockexpression = list;
        return _xblockexpression;
    }

    private List<PropertySerializer> getAttributesSerializer(Metaclass metaclass) {
        ArrayList<PropertySerializer> _xblockexpression = null;
        ArrayList<PropertySerializer> list = new ArrayList<PropertySerializer>();
        List<PropertySerializer> _properties = metaclass.getProperties();
        Consumer<PropertySerializer> _function = it -> list.add((PropertySerializer)it);
        _properties.forEach(_function);
        Map<String, PropertySerializer> _attributes = metaclass.getAttributes();
        Set<Map.Entry<String, PropertySerializer>> _entrySet = _attributes.entrySet();
        Consumer<Map.Entry> _function_1 = it -> {
            PropertySerializer _value = (PropertySerializer)it.getValue();
            list.add(_value);
        };
        _entrySet.forEach(_function_1);
        _xblockexpression = list;
        return _xblockexpression;
    }
}

