/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIConfiguration;
import java.nio.ByteBuffer;

public final class EMIProtocolConfigurationDiff {
    public static final int SIZEOF_CONFIGURATION_DIFF = 5;

    private EMIProtocolConfigurationDiff() {
    }

    public static EMIConfiguration createConfiguration(byte[] data, EMIConfiguration referenceConfiguration) {
        EMIConfiguration configuration = referenceConfiguration.createCopy();
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        for (int i = 0; i < byteBuffer.capacity(); i += 5) {
            configuration.getData().put(byteBuffer.getInt(i), byteBuffer.get(i + 4));
        }
        return configuration;
    }

    public static byte[] createConfigurationDiff(EMIConfiguration configuration, EMIConfiguration referenceConfiguration) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(configuration.countDiffBytes(referenceConfiguration) * 5);
        for (int i = 0; i < configuration.getSize(); ++i) {
            if (referenceConfiguration.getData().get(i) == configuration.getData().get(i)) continue;
            byteBuffer.putInt(i);
            byteBuffer.put(configuration.getData().get(i));
        }
        return byteBuffer.array();
    }
}

