/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.model;

import emi.analysis.annotation.SuppressFBWarnings;
import emi.analysis.exception.EMIException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class EMIAtom {
    public static final String DIGEST_ALGORITHM = "MD5";
    public static final int SIZEOF_ATOM_ID = 16;
    private byte[] id;
    private String idHexa;
    public static final int SIZEOF_ATOM_PRIORITY = 1;
    private byte priority;
    private String stringCode;

    public EMIAtom(String stringCode) throws EMIException {
        this(stringCode, 0);
    }

    public EMIAtom(String stringCode, byte priority) throws EMIException {
        try {
            this.id = MessageDigest.getInstance(DIGEST_ALGORITHM).digest(stringCode.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new EMIException("EMI Atom exception: cannot generate atom id (" + e.getMessage() + ")");
        }
        this.idHexa = DatatypeConverter.printHexBinary((byte[])this.id);
        this.stringCode = stringCode;
        this.priority = priority;
    }

    public EMIAtom(int id, String stringCode) {
        this(id, stringCode, 0);
    }

    public EMIAtom(int id, String stringCode, byte priority) {
        this.id = ByteBuffer.allocate(16).putInt(id).array();
        this.idHexa = DatatypeConverter.printHexBinary((byte[])this.id);
        this.stringCode = stringCode;
        this.priority = priority;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="avoid unnecessary id clone")
    public EMIAtom(byte[] id, String stringCode, byte priority) {
        this.id = id;
        this.idHexa = DatatypeConverter.printHexBinary((byte[])this.id);
        this.stringCode = stringCode;
        this.priority = priority;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="avoid unnecessary id clone")
    public byte[] getId() {
        return this.id;
    }

    public String getIdHexa() {
        return this.idHexa;
    }

    public byte getPriority() {
        return this.priority;
    }

    public String getStringCode() {
        return this.stringCode;
    }

    public int length() {
        return this.getStringCode().length();
    }

    public String toString() {
        return "[" + this.idHexa + ", " + this.priority + ", " + this.stringCode + "]";
    }
}

