/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import java.util.ArrayList;
import java.util.Map;
import obp.fiacre.checker.type.CArray;
import obp.fiacre.checker.type.CQueue;
import obp.fiacre.checker.type.CRecord;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.CUnion;
import obp.fiacre.model.TypeDecl;

public class CTypeUtil {
    public static TypeDecl findType(CType type, Map<CType, TypeDecl> converted) {
        ArrayList<TypeDecl> assignable = new ArrayList<TypeDecl>();
        ArrayList<TypeDecl> equals = new ArrayList<TypeDecl>();
        for (CType existing : converted.keySet()) {
            if (!type.isAssignableFrom(existing)) continue;
            assignable.add(converted.get(existing));
            if (!existing.resolve().equals(type.resolve())) continue;
            equals.add(converted.get(existing));
        }
        if (equals.size() == 1) {
            return (TypeDecl)equals.get(0);
        }
        if (assignable.isEmpty()) {
            throw new IllegalArgumentException("Can't find type declaration for '" + type + "'.");
        }
        if (assignable.size() > 1) {
            throw new IllegalArgumentException("Found more than one type declaration for '" + type + "'.");
        }
        return (TypeDecl)assignable.get(0);
    }

    public static CType arrayOrQueueOf(CType inner) {
        if ((inner = inner.resolve()) instanceof CArray) {
            return CTypeUtil.arrayOrQueueOf(((CArray)inner).getInner());
        }
        if (inner instanceof CQueue) {
            return CTypeUtil.arrayOrQueueOf(((CQueue)inner).getInner());
        }
        return inner;
    }

    public static int arrayOrQueueDimension(CType inner) {
        if ((inner = inner.resolve()) instanceof CArray) {
            return 1 + CTypeUtil.arrayOrQueueDimension(((CArray)inner).getInner());
        }
        if (inner instanceof CQueue) {
            return 1 + CTypeUtil.arrayOrQueueDimension(((CQueue)inner).getInner());
        }
        return 1;
    }

    public static boolean isGeneratedClassType(CType type) {
        return (type = type.resolve()) instanceof CRecord || type instanceof CUnion;
    }

    public static boolean needDeepMethod(CType inner) {
        if (CTypeUtil.arrayOrQueueDimension(inner = inner.resolve()) > 1) {
            return true;
        }
        return CTypeUtil.isGeneratedClassType(inner);
    }
}

