/*
 * Decompiled with CFR 0.152.
 */
package c.builder;

import c.model.ArgumentDeclaration;
import c.model.ArrayType;
import c.model.AssignmentStmt;
import c.model.BinaryExpression;
import c.model.BinaryOperator;
import c.model.Block;
import c.model.BooleanType;
import c.model.CastExpression;
import c.model.CharType;
import c.model.CompilationUnit;
import c.model.Container;
import c.model.Expression;
import c.model.ExternalType;
import c.model.ForStmt;
import c.model.FunctionCall;
import c.model.FunctionDeclaration;
import c.model.IncludeDeclaration;
import c.model.IndexedExpression;
import c.model.IntegerLiteral;
import c.model.IntegerType;
import c.model.Literal;
import c.model.MacroCallStmt;
import c.model.ModelFactory;
import c.model.PointerType;
import c.model.ReturnStmt;
import c.model.SizeOf;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.StringLiteral;
import c.model.StructureDereference;
import c.model.StructureReference;
import c.model.Type;
import c.model.UnaryExpression;
import c.model.UnaryOperator;
import c.model.VariableDeclaration;
import c.model.VariableReference;
import c.model.VoidPointerType;
import c.model.VoidType;
import java.math.BigInteger;

public class CBuilder {
    public static final CBuilder instance = new CBuilder();
    ModelFactory cFactory = ModelFactory.eINSTANCE;

    public CompilationUnit compilationUnit() {
        return this.cFactory.createCompilationUnit();
    }

    public IncludeDeclaration include(String hinc) {
        IncludeDeclaration inc = this.cFactory.createIncludeDeclaration();
        inc.setData(hinc);
        return inc;
    }

    public FunctionDeclaration fdecl(String beforeReturn, Type returnType, String afterReturn, String name, Container owner) {
        FunctionDeclaration cFct = this.cFactory.createFunctionDeclaration();
        cFct.setBeforeReturn(beforeReturn);
        cFct.setAfterReturn(afterReturn);
        cFct.setName(name);
        cFct.setOwner(owner);
        cFct.setType(returnType);
        return cFct;
    }

    public ExternalType externalType(String name) {
        ExternalType eType = this.cFactory.createExternalType();
        eType.setName(name);
        return eType;
    }

    public PointerType pointerType(Type baseType) {
        PointerType type = this.cFactory.createPointerType();
        type.setPointee(baseType);
        return type;
    }

    public VariableDeclaration variable(String name) {
        VariableDeclaration var = this.cFactory.createVariableDeclaration();
        var.setName(name);
        return var;
    }

    public VariableDeclaration variable(String name, Type type) {
        VariableDeclaration var = this.cFactory.createVariableDeclaration();
        var.setName(name);
        var.setType(type);
        return var;
    }

    public VariableDeclaration variable(String name, Type type, Expression initial) {
        VariableDeclaration var = this.cFactory.createVariableDeclaration();
        var.setName(name);
        var.setType(type);
        var.setInitialValue(initial);
        return var;
    }

    public BinaryExpression binaryExpression(Expression lhs, BinaryOperator op, Expression rhs) {
        BinaryExpression bExp = this.cFactory.createBinaryExpression();
        bExp.setOperator(op);
        bExp.getOperands().add(lhs);
        bExp.getOperands().add(rhs);
        return bExp;
    }

    public BinaryExpression mult(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MULT, rhs);
    }

    public BinaryExpression plus(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.PLUS, rhs);
    }

    public BinaryExpression minus(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MINUS, rhs);
    }

    public BinaryExpression div(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.DIV, rhs);
    }

    public BinaryExpression mod(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MOD, rhs);
    }

    public BinaryExpression rshift(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.RSHIFT, rhs);
    }

    public BinaryExpression lt(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.LT, rhs);
    }

    public BinaryExpression leq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.LEQ, rhs);
    }

    public BinaryExpression gt(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.GT, rhs);
    }

    public BinaryExpression geq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.GEQ, rhs);
    }

    public BinaryExpression inc(Expression lhs) {
        return this.plus(lhs, this.literal(1));
    }

    public UnaryExpression address(Expression operand) {
        UnaryExpression dRef = this.cFactory.createUnaryExpression();
        dRef.setOperator(UnaryOperator.ADDRESS);
        dRef.setOperand(operand);
        return dRef;
    }

    public UnaryExpression dereference(Expression exp) {
        UnaryExpression re = this.cFactory.createUnaryExpression();
        re.setOperator(UnaryOperator.DEREFERENCE);
        re.setOperand(exp);
        return re;
    }

    public StructureDereference dereference(Expression base, String memberName) {
        StructureDereference member = this.cFactory.createStructureDereference();
        member.setBase(base);
        member.setMember(memberName);
        return member;
    }

    public VariableReference reference(ArgumentDeclaration var) {
        VariableReference c = this.cFactory.createVariableReference();
        c.setRefersTo(var);
        return c;
    }

    public StructureReference reference(Expression base, String memberName) {
        StructureReference lexp = this.cFactory.createStructureReference();
        lexp.setBase(base);
        lexp.setMember(memberName);
        return lexp;
    }

    public IndexedExpression indexed(Expression base, Expression index) {
        IndexedExpression iExp = this.cFactory.createIndexedExpression();
        iExp.setBase(base);
        iExp.setIndex(index);
        return iExp;
    }

    public FunctionCall functionCall(Expression fctExp) {
        FunctionCall fCall = this.cFactory.createFunctionCall();
        fCall.setFunctionExp(fctExp);
        return fCall;
    }

    public FunctionCall functionCall(String name) {
        FunctionCall fCall = this.cFactory.createFunctionCall();
        fCall.setName(name);
        return fCall;
    }

    public FunctionCall functionCall(FunctionDeclaration decl) {
        FunctionCall fCall = this.cFactory.createFunctionCall();
        fCall.setCalledFunction(decl);
        return fCall;
    }

    public CastExpression cast(Type type, Expression exp) {
        CastExpression cExp = this.cFactory.createCastExpression();
        cExp.setExpression(exp);
        cExp.setType(type);
        return cExp;
    }

    public Literal literal(String s) {
        StringLiteral sLit = this.cFactory.createStringLiteral();
        sLit.setValue(s);
        return sLit;
    }

    public Literal literal(int i) {
        IntegerLiteral iLit = this.cFactory.createIntegerLiteral();
        iLit.setValue(BigInteger.valueOf(i));
        return iLit;
    }

    public MacroCallStmt macroCall(String name) {
        MacroCallStmt mC = this.cFactory.createMacroCallStmt();
        mC.setName(name);
        return mC;
    }

    public Expression sizeOf(Type type) {
        SizeOf sizeOf = this.cFactory.createSizeOf();
        sizeOf.setType(type);
        return sizeOf;
    }

    public AssignmentStmt assign(Expression lhs, Expression rhs) {
        AssignmentStmt a = this.cFactory.createAssignmentStmt();
        a.setL_value(lhs);
        a.setR_value(rhs);
        return a;
    }

    public ForStmt forStmt(Statement initial, Expression condition, Statement step) {
        ForStmt forS = this.cFactory.createForStmt();
        forS.setInitial(initial);
        forS.setCondition(condition);
        forS.setStep(step);
        return forS;
    }

    public ReturnStmt returnStmt(Expression returnExp) {
        ReturnStmt rS = this.cFactory.createReturnStmt();
        rS.setExpression(returnExp);
        return rS;
    }

    public StatementGroup block(Container owner) {
        Block sG = this.cFactory.createBlock();
        sG.setOwner(owner);
        return sG;
    }

    public StatementGroup statementGroup(Container owner) {
        StatementGroup sG = this.cFactory.createStatementGroup();
        sG.setOwner(owner);
        return sG;
    }

    public VoidPointerType voidPointerType() {
        return this.cFactory.createVoidPointerType();
    }

    public CharType charType() {
        return this.cFactory.createCharType();
    }

    public ArrayType arrayType(Type elementType) {
        ArrayType aT = this.cFactory.createArrayType();
        aT.setElementType(elementType);
        return aT;
    }

    public Expression nullLiteral() {
        return this.cFactory.createNullLiteral();
    }

    public ArgumentDeclaration argumentDecl(String name) {
        ArgumentDeclaration argD = this.cFactory.createArgumentDeclaration();
        argD.setName(name);
        return argD;
    }

    public ArgumentDeclaration argumentDecl(String name, Type type) {
        ArgumentDeclaration argD = this.cFactory.createArgumentDeclaration();
        argD.setName(name);
        argD.setType(type);
        return argD;
    }

    public VoidType voidType() {
        return this.cFactory.createVoidType();
    }

    public BooleanType booleanType() {
        return this.cFactory.createBooleanType();
    }

    public IntegerType integerType() {
        return this.cFactory.createIntegerType();
    }
}

