/*
 * Decompiled with CFR 0.152.
 */
package spinja.util;

public class CharacterQueue {
    private int head;
    private int tail;
    private int size;
    private char[] buffer;

    public CharacterQueue() {
        this(10);
    }

    public CharacterQueue(int n) {
        this.buffer = new char[n];
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public void add(char c) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.tail] = c;
        this.tail = (this.tail + 1) % this.buffer.length;
        ++this.size;
    }

    public void add(char[] cArray) {
        this.add(cArray, 0, cArray.length);
    }

    public void add(char[] cArray, int n, int n2) {
        this.ensureCapacity(this.size + n2);
        int n3 = this.buffer.length - this.tail;
        if (n2 < n3) {
            System.arraycopy(cArray, n, this.buffer, this.tail, n2);
        } else {
            System.arraycopy(cArray, n, this.buffer, this.tail, n3);
            System.arraycopy(cArray, n, this.buffer, 0, n2 - n3);
        }
        this.tail = (this.tail + n2) % this.buffer.length;
        this.size += n2;
    }

    public char get(int n) {
        return this.buffer[this.convertIndex(n)];
    }

    public char peek() {
        return this.buffer[this.head];
    }

    public char remove() {
        char c = this.buffer[this.head];
        this.head = (this.head + 1) % this.buffer.length;
        --this.size;
        return c;
    }

    public int getSize() {
        return this.size;
    }

    private void ensureCapacity(int n) {
        if (n > 0x3FFFFFFF) {
            throw new IllegalArgumentException("length can not be larger than Integer.MAX_VALUE / 2");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("length must be larger than zero");
        }
        if (n > this.buffer.length) {
            int n2;
            for (n2 = this.buffer.length * 2; n > n2; n2 *= 2) {
            }
            char[] cArray = new char[n2];
            int n3 = this.buffer.length - this.head;
            if (n3 < this.size) {
                System.arraycopy(this.buffer, this.head, cArray, 0, n3);
                System.arraycopy(this.buffer, 0, cArray, n3, this.size - n3);
            } else {
                System.arraycopy(this.buffer, this.head, cArray, 0, this.size);
            }
            this.head = 0;
            this.tail = this.size;
            this.buffer = cArray;
        }
    }

    private final int convertIndex(int n) {
        return (n + this.head) % this.buffer.length;
    }
}

