/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import java.util.Arrays;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.store.hash.HsiehHash;
import spinja.store.hash.JenkinsHash;

public class HashCompactStore
extends StateStore {
    final HashAlgorithm probingHash;
    final HashAlgorithm compressingHash;
    private Table table;

    public HashCompactStore(int n, int n2) {
        this(n, n2, new JenkinsHash(), new HsiehHash());
    }

    public HashCompactStore(int n, int n2, HashAlgorithm hashAlgorithm, HashAlgorithm hashAlgorithm2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Both the bitSize as well as the nr of entries must be positive for the hash compaction algorithm.");
        }
        if ((n2 & 7) != 0) {
            throw new IllegalArgumentException("Only multiple of 8 bits are supported as bitsize.");
        }
        switch (n2) {
            case 32: {
                this.table = new HashCompactStore32(n);
                break;
            }
            case 40: {
                this.table = new HashCompactStore40(n);
                break;
            }
            case 48: {
                this.table = new HashCompactStore48(n);
                break;
            }
            case 56: {
                this.table = new HashCompactStore56(n);
                break;
            }
            case 64: {
                this.table = new HashCompactStore64(n);
                break;
            }
            default: {
                this.table = new HashCompactStoreAny(n, n2 >>> 3);
            }
        }
        this.probingHash = hashAlgorithm2;
        this.compressingHash = hashAlgorithm;
    }

    @Override
    public int addState(byte[] byArray) {
        return this.table.addState(byArray);
    }

    @Override
    public long getBytes() {
        return this.table.getBytes() + 12L;
    }

    @Override
    public int getStored() {
        return this.table.getStored();
    }

    private class HashCompactStoreAny
    extends Table {
        private final byte[][] table;
        private final int bytesPerEntry;
        private int filled;

        public HashCompactStoreAny(int n, int n2) {
            super(4 * (1 << n) + 12, (1 << n) - 1);
            this.filled = 0;
            this.bytesPerEntry = n2;
            this.table = new byte[1 << n][];
        }

        @Override
        public int addState(byte[] byArray) {
            byte[] byArray2 = new byte[this.bytesPerEntry];
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.compressingHash.hash(byArray);
            int n = 0;
            int n2 = hashGenerator.currentHash();
            while (n < this.bytesPerEntry - 3) {
                byArray2[n++] = (byte)n2;
                byArray2[n++] = (byte)(n2 >> 8);
                byArray2[n++] = (byte)(n2 >> 16);
                byArray2[n++] = (byte)(n2 >> 24);
                n2 = hashGenerator.nextHash();
            }
            switch (this.bytesPerEntry - n) {
                case 3: {
                    byArray2[n++] = (byte)n2;
                }
                case 2: {
                    byArray2[n++] = (byte)(n2 >> 8);
                }
                case 1: {
                    byArray2[n++] = (byte)(n2 >> 16);
                }
            }
            HashAlgorithm.HashGenerator hashGenerator2 = HashCompactStore.this.probingHash.hash(byArray);
            int n3 = hashGenerator2.currentHash() & this.mask;
            while (this.table[n3] != null) {
                if (Arrays.equals(this.table[n3], byArray2)) {
                    return -(hashGenerator2.currentHash() & Integer.MAX_VALUE) - 1;
                }
                n3 = hashGenerator2.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n3] = byArray2;
            ++this.stored;
            ++this.filled;
            return hashGenerator2.currentHash() & Integer.MAX_VALUE;
        }

        @Override
        public long getBytes() {
            return super.getBytes() + (long)((this.bytesPerEntry + 16) * this.filled);
        }
    }

    private class HashCompactStore64
    extends Table {
        private final long[] table;

        public HashCompactStore64(int n) {
            super(8L * (long)(1 << n) + 4L, (1 << n) - 1);
            this.table = new long[1 << n];
        }

        @Override
        public int addState(byte[] byArray) {
            long l = 0L;
            long l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            while (l2 == 0L) {
                l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            }
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.probingHash.hash(byArray);
            int n = hashGenerator.currentHash() & this.mask;
            while (this.table[n] != 0L) {
                if (this.table[n] == l2) {
                    return -((int)l2 & Integer.MAX_VALUE) - 1;
                }
                n = hashGenerator.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n] = l2;
            ++this.stored;
            return (int)l2 & Integer.MAX_VALUE;
        }
    }

    private class HashCompactStore56
    extends Table {
        private final int[] table;
        private final short[] table2;
        private final byte[] table3;

        public HashCompactStore56(int n) {
            super(7L * (long)(1 << n) + 12L, (1 << n) - 1);
            this.table = new int[1 << n];
            this.table2 = new short[1 << n];
            this.table3 = new byte[1 << n];
        }

        @Override
        public int addState(byte[] byArray) {
            long l = 0L;
            long l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            while ((l2 & 0xFFFFFFFFFFL) == 0L) {
                l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            }
            int n = (int)l2;
            short s = (short)(l2 >>> 32);
            byte by = (byte)(l2 >>> 48);
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.probingHash.hash(byArray);
            int n2 = hashGenerator.currentHash() & this.mask;
            while (this.table[n2] != 0 || this.table2[n2] != 0 || this.table3[n2] != 0) {
                if (this.table[n2] == n && this.table2[n2] == s && this.table3[n2] == by) {
                    return -(n & Integer.MAX_VALUE) - 1;
                }
                n2 = hashGenerator.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n2] = n;
            this.table2[n2] = s;
            this.table3[n2] = by;
            ++this.stored;
            return n & Integer.MAX_VALUE;
        }
    }

    private class HashCompactStore48
    extends Table {
        private final int[] table;
        private final short[] table2;

        public HashCompactStore48(int n) {
            super(6L * (long)(1 << n) + 8L, (1 << n) - 1);
            this.table = new int[1 << n];
            this.table2 = new short[1 << n];
        }

        @Override
        public int addState(byte[] byArray) {
            long l = 0L;
            long l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            while ((l2 & 0xFFFFFFFFFFL) == 0L) {
                l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            }
            int n = (int)l2;
            short s = (short)(l2 >>> 32);
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.probingHash.hash(byArray);
            int n2 = hashGenerator.currentHash() & this.mask;
            while (this.table[n2] != 0 || this.table2[n2] != 0) {
                if (this.table[n2] == n && this.table2[n2] == s) {
                    return -(n & Integer.MAX_VALUE) - 1;
                }
                n2 = hashGenerator.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n2] = n;
            this.table2[n2] = s;
            ++this.stored;
            return n & Integer.MAX_VALUE;
        }
    }

    private class HashCompactStore40
    extends Table {
        private final int[] table;
        private final byte[] table2;

        public HashCompactStore40(int n) {
            super(5L * (long)(1 << n) + 8L, (1 << n) - 1);
            this.table = new int[1 << n];
            this.table2 = new byte[1 << n];
        }

        @Override
        public int addState(byte[] byArray) {
            long l = 0L;
            long l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            while ((l2 & 0xFFFFFFFFFFL) == 0L) {
                l2 = HashCompactStore.this.compressingHash.hash(byArray, l++);
            }
            int n = (int)l2;
            byte by = (byte)(l2 >>> 32);
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.probingHash.hash(byArray);
            int n2 = hashGenerator.currentHash() & this.mask;
            while (this.table[n2] != 0 || this.table2[n2] != 0) {
                if (this.table[n2] == n && this.table2[n2] == by) {
                    return -(n & Integer.MAX_VALUE) - 1;
                }
                n2 = hashGenerator.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n2] = n;
            this.table2[n2] = by;
            ++this.stored;
            return n & Integer.MAX_VALUE;
        }
    }

    private class HashCompactStore32
    extends Table {
        private final int[] table;

        public HashCompactStore32(int n) {
            super(4L * (long)(1 << n) + 4L, (1 << n) - 1);
            this.table = new int[1 << n];
        }

        @Override
        public int addState(byte[] byArray) {
            int n = 0;
            int n2 = HashCompactStore.this.compressingHash.hash(byArray, n++);
            while (n2 == 0) {
                n2 = HashCompactStore.this.compressingHash.hash(byArray, n++);
            }
            HashAlgorithm.HashGenerator hashGenerator = HashCompactStore.this.probingHash.hash(byArray);
            int n3 = hashGenerator.currentHash() & this.mask;
            while (this.table[n3] != 0) {
                if (this.table[n3] == n2) {
                    return -(n2 & Integer.MAX_VALUE) - 1;
                }
                n3 = hashGenerator.nextHash() & this.mask;
                ++this.conflicts;
            }
            this.table[n3] = n2;
            ++this.stored;
            return n2 & Integer.MAX_VALUE;
        }
    }

    private abstract class Table
    extends StateStore {
        protected int stored;
        protected final int mask;
        protected long bytes;
        protected long conflicts;

        public Table(long l, int n) {
            this.bytes = l + 12L;
            this.mask = n;
        }

        @Override
        public long getBytes() {
            return this.bytes;
        }

        @Override
        public final int getStored() {
            return this.stored;
        }
    }
}

