/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl;

import java.io.File;
import obp.cdl.CDLUnit;
import obp.util.CDLUtil;

public class OpenedUnit {
    private final File file;
    private CDLUnit unit;
    private long lastModified = -1L;

    public OpenedUnit(File file) {
        this.file = file;
    }

    public void load() throws Exception {
        this.unit = null;
        this.unit = CDLUtil.readCDLAndResolveReferences(this.file);
        this.touch();
    }

    public void touch() {
        this.lastModified = this.file.lastModified();
    }

    public boolean needReload() {
        return this.lastModified < this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public CDLUnit getUnit() {
        return this.unit;
    }
}

