/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;

public class ClockBindingsGenerator {
    private Map<ProcessDecl, StateToWaitList> waitBindings = new HashMap<ProcessDecl, StateToWaitList>();

    public short getWaitOffset(Wait wait) {
        for (StateToWaitList stateToWaitList : this.waitBindings.values()) {
            short result = stateToWaitList.getWaitOffset(wait);
            if (result == -1) continue;
            return result;
        }
        throw new RuntimeException("Unable to locate the provided wait statement.");
    }

    public short getClockIndexRangeSize(ProcessDecl processDecl) {
        StateToWaitList stateToWaitList = this.waitBindings.get(processDecl);
        if (stateToWaitList == null) {
            return 0;
        }
        return stateToWaitList.getClockIndexRangeSize();
    }

    public void computeWaitBindings(Program program) {
        for (Declaration declaration : program.getDeclarationList()) {
            if (!(declaration instanceof ProcessDecl)) continue;
            StateToWaitList visitor = new StateToWaitList();
            visitor.fetch((ProcessDecl)declaration);
            this.waitBindings.put((ProcessDecl)declaration, visitor);
        }
    }

    private class StateToWaitList
    extends ModelVisitor.Stub {
        private String currentStateName;
        private Map<String, List<Wait>> stateToWaitList = new HashMap<String, List<Wait>>();

        private StateToWaitList() {
        }

        public void fetch(ProcessDecl process) {
            process.accept(this);
        }

        private void setCurrentStateName(String name) {
            this.currentStateName = name;
            if (!this.stateToWaitList.containsKey(name)) {
                this.stateToWaitList.put(name, new ArrayList());
            }
        }

        private void addToCurrentState(Wait wait) {
            this.stateToWaitList.get(this.currentStateName).add(wait);
        }

        public short getWaitOffset(Wait wait) {
            for (List<Wait> waitList : this.stateToWaitList.values()) {
                if (!waitList.contains(wait)) continue;
                return (short)waitList.indexOf(wait);
            }
            return -1;
        }

        public short getClockIndexRangeSize() {
            short result = 0;
            for (List<Wait> waitList : this.stateToWaitList.values()) {
                short size = (short)waitList.size();
                result = size > result ? size : result;
            }
            return result;
        }

        @Override
        public void visitProcessDecl(ProcessDecl toVisit) {
            for (Transition transition : toVisit.getTransitionList()) {
                transition.accept(this);
            }
        }

        @Override
        public void visitTransition(Transition toVisit) {
            this.setCurrentStateName(toVisit.getFrom().getName());
            toVisit.getAction().accept(this);
        }

        @Override
        public void visitCaseStmt(CaseStmt toVisit) {
            for (Rule rule : toVisit.getRuleList()) {
                rule.getAction().accept(this);
            }
        }

        @Override
        public void visitForeach(Foreach toVisit) {
            toVisit.getBody().accept(this);
        }

        @Override
        public void visitIfStmt(IfStmt toVisit) {
            toVisit.getThen().accept(this);
            toVisit.getElse().accept(this);
        }

        @Override
        public void visitWhileStmt(WhileStmt toVisit) {
            toVisit.getBody().accept(this);
        }

        @Override
        public void visitSelect(Select toVisit) {
            for (Statement statement : toVisit.getStatementList()) {
                statement.accept(this);
            }
        }

        @Override
        public void visitSeq(Seq toVisit) {
            for (Statement statement : toVisit.getStatementList()) {
                statement.accept(this);
            }
        }

        @Override
        public void visitWait(Wait toVisit) {
            this.addToCurrentState(toVisit);
        }
    }
}

