/*
 * Decompiled with CFR 0.152.
 */
package obp.cc2ifx;

import java.util.HashMap;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.transfo.cc.ConcreteContextCache;
import obp.util.EventUtil;

public class ConcreteContextToIF {
    public static String toProcess(ConcreteContext source) {
        ConcreteContextCache cache = new ConcreteContextCache(source);
        StringBuilder process = new StringBuilder();
        HashMap<State, String> stateMap = new HashMap<State, String>();
        int count = 1;
        for (State sourceState : source.getStateList()) {
            stateMap.put(sourceState, "s" + count);
            ++count;
        }
        process.append("process context(1);\n\n");
        for (State state : source.getStateList()) {
            process.append("state ");
            process.append((String)stateMap.get(state));
            if (state == source.getStartState()) {
                process.append(" #start ");
            }
            process.append(";\n");
            for (Transition transition : cache.getOutTransitions(state)) {
                process.append("\t");
                if (transition.getAction() != null) {
                    process.append(EventUtil.printEvent(transition.getAction().getReference().getIs()));
                }
                process.append("\n");
                process.append("\tnextstate ");
                process.append((String)stateMap.get(transition.getTarget()));
                process.append(";\n\n");
            }
            process.append("endstate;\n\n");
        }
        process.append("endprocess;\n");
        return process.toString();
    }
}

