/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.Method;
import org.xid.basics.model.ChangeMark;
import org.xid.basics.model.ModelObject;

public class AddObjectChangeMark
extends ChangeMark {
    protected final ModelObject receiver;
    protected final String attributeName;
    protected final int index;

    public AddObjectChangeMark(long timestamp, ModelObject receiver, String attributeName, int index) {
        super(timestamp);
        this.receiver = receiver;
        this.attributeName = attributeName;
        this.index = index;
    }

    protected String getRemoverName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "remove" + firstUppercaseAttribute;
    }

    @Override
    public void undo() {
        try {
            Method method = this.getMethod(this.receiver.getClass(), this.getRemoverName(), Integer.TYPE);
            if (method != null) {
                method.invoke((Object)this.receiver, this.index);
            } else {
                System.err.println("AddObjectChangeMark.undo():No method to undo");
            }
        }
        catch (Exception e) {
            System.err.println("AddObjectChangeMark.undo(): " + e.getClass().getName());
        }
    }

    @Override
    public String toString() {
        return "Ad|" + this.attributeName;
    }
}

