/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.java;

import java.util.regex.Pattern;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentFilter;
import org.xid.basics.generation.java.JavaContentHandler;

public class JavaContentFormatter
extends JavaContentFilter {
    private final String NL = System.getProperty("line.separator");
    private final Pattern NL_REGEX = Pattern.compile(this.NL);
    private int level = 0;
    private String indentString;

    public JavaContentFormatter(JavaContentHandler target, String indentString) {
        super(target);
        this.indentString = indentString;
    }

    public JavaContentFormatter(JavaContentHandler target) {
        this(target, "\t");
    }

    @Override
    public void annotation(String name, String parameters) {
        super.codeln(0, this.indentation(this.level));
        super.annotation(name, parameters);
    }

    @Override
    public void beginAttribute(int flags, String type, String name) {
        super.codeln(0, this.indentation(this.level));
        super.beginAttribute(flags, type, name);
    }

    @Override
    public void endAttribute(String name) {
        super.endAttribute(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginAnonymousClass(String inherited, String ... arguments) {
        super.codeln(0, this.indentation(this.level++));
        super.beginAnonymousClass(inherited, arguments);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginClass(int flags, String name, String parentClass, String implementedInterfaces) {
        super.codeln(0, this.indentation(this.level++));
        super.beginClass(flags, name, parentClass, implementedInterfaces);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginEnum(int flags, String name) {
        super.codeln(0, this.indentation(this.level++));
        super.beginEnum(flags, name);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginEnumLiterals() {
        super.beginEnumLiterals();
    }

    @Override
    public void enumLiteral(String name, String ... arguments) {
        super.enumLiteral(name, arguments);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginFile(String name) {
        super.beginFile(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginInterface(int flags, String name, String extendedInterfaces) {
        super.codeln(0, this.indentation(this.level++));
        super.beginInterface(flags, name, extendedInterfaces);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginMethod(int flags, String returnType, String name, String exceptions, Java.Parameter ... parameters) {
        super.codeln(0, this.indentation(this.level++));
        super.beginMethod(flags, returnType, name, exceptions, parameters);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginPackage(String name) {
        super.beginPackage(name);
    }

    @Override
    public void endAnnonymousClass(String inherited) {
        super.codeln(0, this.indentation(--this.level));
        super.endAnnonymousClass(inherited);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endClass(String name) {
        super.codeln(0, this.indentation(--this.level));
        super.endClass(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endEnumLiterals() {
        super.endEnumLiterals();
        super.codeln(0, this.NL);
    }

    @Override
    public void endEnum(String name) {
        --this.level;
        super.codeln(0, this.indentation(this.level));
        super.endEnum(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endFile(String name) {
        super.endFile(name);
    }

    @Override
    public void endInterface(String name) {
        super.codeln(0, this.indentation(--this.level));
        super.endInterface(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endMethod(String name) {
        super.codeln(0, this.indentation(--this.level));
        super.endMethod(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endPackage(String name) {
        super.endPackage(name);
    }

    @Override
    public void markImports() {
        super.markImports();
    }

    @Override
    public void import_(int flags, String importString) {
        super.import_(flags, importString);
    }

    @Override
    public void codeln(int localLevel, String statements) {
        String[] lines;
        for (String line : lines = this.NL_REGEX.split(statements)) {
            super.codeln(this.level + localLevel, this.indentation(this.level + localLevel));
            super.codeln(this.level + localLevel, line);
            super.codeln(this.level + localLevel, this.NL);
        }
    }

    @Override
    public void code(String statements) {
        super.code(statements);
    }

    @Override
    public void comment(int type, int localLevel, String comment) {
        int innerLevel = this.level + localLevel;
        switch (type) {
            case 1: {
                super.codeln(0, this.indentation(innerLevel));
                super.comment(type, localLevel, comment);
                break;
            }
            case 2: 
            case 3: {
                String[] lines = this.NL_REGEX.split(comment);
                super.codeln(localLevel, this.indentation(innerLevel));
                super.codeln(localLevel, type == 3 ? "/**" : "/*");
                super.codeln(innerLevel, this.NL);
                for (int i = 0; i < lines.length; ++i) {
                    super.codeln(localLevel, this.indentation(innerLevel));
                    if (!lines[i].startsWith(" *")) {
                        super.codeln(localLevel, " * ");
                    }
                    super.codeln(localLevel, lines[i]);
                    super.codeln(localLevel, this.NL);
                }
                super.codeln(localLevel, this.indentation(innerLevel));
                super.codeln(localLevel, " */");
                super.codeln(localLevel, this.NL);
            }
        }
    }

    private String indentation(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append(this.indentString);
        }
        return result.toString();
    }
}

