/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.CompoundExpression;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.ChannelVariable;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class PrintAction
extends Action
implements CompoundExpression {
    private final String string;
    private final List<Expression> exprs;

    public PrintAction(Token token, String string) {
        super(token);
        this.string = string;
        this.exprs = new ArrayList<Expression>();
    }

    @Override
    public void addExpression(Expression expression) {
        this.exprs.add(expression);
    }

    private String escapedString() {
        StringBuilder stringBuilder = new StringBuilder(this.string.length());
        for (int i = 0; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            if (c >= ' ' && c <= '~') {
                if (c == '\"') {
                    stringBuilder.append("\\\"");
                    continue;
                }
                if (c == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u" + Integer.toHexString(c));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getEnabledExpression() {
        return null;
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        for (Expression expression : this.exprs) {
            for (VariableAccess variableAccess : expression.readVariables()) {
                if (proctype.hasVariable(variableAccess.getVar().getName()) && !(variableAccess.getVar() instanceof ChannelVariable)) continue;
                return false;
            }
        }
        return super.isLocal(proctype);
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        stringWriter.appendPrefix().append("printf(").append(this.string);
        for (Expression expression : this.exprs) {
            stringWriter.append(", ").append(expression.getIntExpression());
        }
        stringWriter.append(");").appendPostfix();
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            stringWriter.append("printf(").append(this.escapedString());
            for (Expression expression : this.exprs) {
                stringWriter.append(", ").append(expression.getIntExpression());
            }
            stringWriter.append(");");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

