/*
 * Decompiled with CFR 0.152.
 */
package spinja;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import spinja.Version;
import spinja.concurrent.model.ConcurrentModel;
import spinja.concurrent.search.PartialOrderReduction;
import spinja.exceptions.ValidationException;
import spinja.options.BooleanOption;
import spinja.options.MultiStringOption;
import spinja.options.NumberOption;
import spinja.options.OptionParser;
import spinja.promela.model.NeverClaimModel;
import spinja.promela.model.PromelaModel;
import spinja.promela.model.PromelaTransition;
import spinja.search.AcceptanceCycleSearch;
import spinja.search.Algoritm;
import spinja.search.BreadthFirstSearch;
import spinja.search.ConcurrentBFSearch;
import spinja.search.DepthFirstSearch;
import spinja.search.RandomSimulation;
import spinja.search.TrailSimulation;
import spinja.search.TransitionCalculator;
import spinja.search.UserSimulation;
import spinja.store.AtomicHashTable;
import spinja.store.BitstateHashStore;
import spinja.store.HashCompactStore;
import spinja.store.HashTable;
import spinja.store.ProbingHashTable;
import spinja.store.StateStore;

public class Run
extends Thread {
    private StateStore store = null;
    private Algoritm algo = null;
    private double startTime;
    private final MultiStringOption impl = new MultiStringOption('D', "use a specific implementation option", new String[]{"BFS", "NOREDUCE", "BITSTATE", "HC", "ARRAY", "GTRAIL", "GUSER", "GRANDOM"}, new String[]{"uses a Breadth First Search algorithm", "disables the partial order reduction algoritm", "uses bitstate hashing for storing states\n(this method does not guarantee a complete search)", "uses hash compaction for storing states \n(this method does not guarantee a complete search)", "uses a hash table that uses array lists \ninstead of probing", "uses the trail-file to guide the search", "uses user input to guide the search", "uses a randomizer to guide the search"});
    private final BooleanOption checkAccept = new BooleanOption('a', "checks for acceptance cycles");
    private final BooleanOption ignoreAssert = new BooleanOption('A', "assert statements will be ignored");
    private final BooleanOption errorExceedDepth = new BooleanOption('b', "exceeding the depth limit is considered an error");
    private final NumberOption nrErrors = new NumberOption('c', "stops the verification after N errors \n(when set to 0 it does not stop for any error)", 1, 0, Integer.MAX_VALUE);
    private final NumberOption concurrent = new NumberOption('C', "starts several concurrent threads (*experimental*)", 1, 1, 1024);
    private final BooleanOption ignoreInvalidEnd = new BooleanOption('E', "ignore invalid end states (deadlocks)");
    private final NumberOption nrBits = new NumberOption('k', "sets N bits per state when using bitstate hashing", 3, 1, 1024);
    private final NumberOption maxDepth = new NumberOption('m', "sets the maximum search depth", 10000, 1, Integer.MAX_VALUE);
    private final BooleanOption ignoreNever = new BooleanOption('N', "ignores any never claim (if present)");
    private final BooleanOption onlyVersion = new BooleanOption('v', "prints the version number and exits");
    private final NumberOption hashEntries = new NumberOption('w', "sets the number of entries in the hash table to 2^N", 21, 3, 31);
    private byte done = 0;
    private TransitionCalculator<ConcurrentModel<PromelaTransition>, PromelaTransition> nextTransition = null;

    public boolean getIgnoreAssert() {
        return this.ignoreAssert.isSet();
    }

    public boolean getIgnoreNever() {
        return this.ignoreNever.isSet();
    }

    public boolean getIgnoreInvalidEnd() {
        return this.ignoreInvalidEnd.isSet();
    }

    public void parseArguments(String[] stringArray, String string) {
        String string2 = "SpinJa Model Checker - version " + Version.VERSION + " (" + Version.DATE + ")\n" + "(C) University of Twente, Formal Methods and Tools group";
        OptionParser optionParser = new OptionParser("java spinja." + string + "Model", string2, "SpinJa Model Checker is a (generated) Java program which verifies\nwhether the original Promela model (+ never claim) was correct.", false);
        optionParser.addOption(this.impl);
        optionParser.addOption(this.checkAccept);
        optionParser.addOption(this.ignoreAssert);
        optionParser.addOption(this.errorExceedDepth);
        optionParser.addOption(this.concurrent);
        optionParser.addOption(this.nrErrors);
        optionParser.addOption(this.ignoreInvalidEnd);
        optionParser.addOption(this.nrBits);
        optionParser.addOption(this.maxDepth);
        optionParser.addOption(this.ignoreNever);
        optionParser.addOption(this.onlyVersion);
        optionParser.addOption(this.hashEntries);
        optionParser.parse(stringArray);
    }

    private boolean realMem() {
        Runtime runtime = Runtime.getRuntime();
        runtime.runFinalization();
        for (int i = 0; i < 16; ++i) {
            runtime.gc();
        }
        double d = (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0;
        System.out.printf("%7g real memory usage (Mbyte)\n", d);
        return true;
    }

    @Override
    public void run() {
        if (this.done == 0) {
            System.out.println("Warning: Search not completed!");
        } else if (this.done == -1) {
            return;
        }
        this.algo.printSummary();
        double d = (double)this.algo.getBytes() / 1048576.0;
        System.out.printf("%7g memory usage (Mbyte)\n", d);
        System.out.println();
        double d2 = ((double)System.currentTimeMillis() - this.startTime) / 1000.0;
        System.out.printf("spinja: elapsed time %.2f seconds\n", d2);
        System.out.printf("spinja: rate %8d states/second\n", (int)((double)this.algo.getNrStates() / d2));
        this.realMem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Class<? extends PromelaModel> clazz) {
        boolean bl;
        Runtime.getRuntime().addShutdownHook(this);
        if (this.onlyVersion.isSet()) {
            this.done = (byte)-1;
            return;
        }
        ConcurrentModel<PromelaTransition> concurrentModel = null;
        try {
            concurrentModel = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("The process model should have at least a contructor with one boolean as a parameter.");
            illegalArgumentException.printStackTrace();
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("The process model should have at least an accesable contructor with one boolean as a parameter.");
            securityException.printStackTrace();
            return;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException.getCause().getMessage());
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return;
        }
        if (!this.ignoreNever.isSet()) {
            try {
                concurrentModel = NeverClaimModel.createNever((PromelaModel)concurrentModel);
                if (concurrentModel instanceof NeverClaimModel) {
                    this.ignoreInvalidEnd.parseOption(null);
                }
            }
            catch (ValidationException validationException) {
                System.out.println("Warning: Could not create never-claim: " + validationException.getMessage());
            }
        }
        boolean bl2 = this.impl.isSet("GUSER") || this.impl.isSet("GTRAIL") || this.impl.isSet("GRANDOM");
        boolean bl3 = bl = !this.impl.isSet("NOREDUCE");
        if (bl) {
            System.out.println("        + Partial Order Reduction");
            this.nextTransition = new PartialOrderReduction<ConcurrentModel<PromelaTransition>, PromelaTransition>();
        } else {
            this.nextTransition = new TransitionCalculator();
        }
        System.out.println();
        System.out.println("Full statespace search for:");
        System.out.print("        never claim             ");
        System.out.println(concurrentModel instanceof NeverClaimModel ? "+" : "-");
        System.out.print("        assertion violations    ");
        System.out.println(this.getIgnoreAssert() ? "-" : "+");
        System.out.print("        cycle checks            ");
        System.out.println(this.checkAccept.isSet() ? "+ Acceptance cycles" : "-");
        System.out.print("        invalid end states      ");
        System.out.println(this.ignoreInvalidEnd.isSet() ? "-" : "+");
        System.out.println();
        int n = this.maxDepth.getValue();
        if (!bl2) {
            this.store = this.concurrent.getValue() > 1 ? new AtomicHashTable(this.hashEntries.getValue()) : (this.impl.isSet("BITSTATE") ? new BitstateHashStore(this.hashEntries.getValue(), this.nrBits.getValue()) : (this.impl.isSet("HC") ? new HashCompactStore(this.hashEntries.getValue(), this.nrBits.getValue()) : (this.impl.isSet("ARRAY") ? new HashTable(this.hashEntries.getValue()) : new ProbingHashTable(this.hashEntries.getValue()))));
        }
        if (this.impl.isSet("GUSER")) {
            this.algo = new UserSimulation<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.nextTransition);
        } else if (this.impl.isSet("GTRAIL")) {
            try {
                this.algo = new TrailSimulation<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.nextTransition);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Could not find trail-file: " + fileNotFoundException.getMessage());
                return;
            }
        } else {
            this.algo = this.impl.isSet("GRANDOM") ? new RandomSimulation<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.nextTransition) : (this.impl.isSet("BFS") ? new BreadthFirstSearch<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.store, this.errorExceedDepth.isSet(), this.nrErrors.getValue(), !this.ignoreInvalidEnd.isSet(), this.nextTransition) : (this.concurrent.getValue() > 1 ? new ConcurrentBFSearch<ConcurrentModel<PromelaTransition>, PromelaTransition>(this.concurrent.getValue(), concurrentModel, this.store, !this.ignoreInvalidEnd.isSet(), this.nrErrors.getValue(), this.errorExceedDepth.isSet(), this.nextTransition) : (this.checkAccept.isSet() ? new AcceptanceCycleSearch<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.store, n, this.errorExceedDepth.isSet(), !this.ignoreInvalidEnd.isSet(), this.nrErrors.getValue(), this.nextTransition) : new DepthFirstSearch<ConcurrentModel<PromelaTransition>, PromelaTransition>(concurrentModel, this.store, n, this.errorExceedDepth.isSet(), !this.ignoreInvalidEnd.isSet(), this.nrErrors.getValue(), this.nextTransition))));
        }
        this.startTime = System.currentTimeMillis();
        try {
            this.algo.execute();
            this.done = 1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.algo.freeMemory();
            System.out.println("spinja error: Maximum memory reached. Please make more memory available for the virtual machine.");
        }
        finally {
            if (this.concurrent.getValue() > 1) {
                AtomicHashTable atomicHashTable = (AtomicHashTable)this.store;
                atomicHashTable.shutdown();
                try {
                    atomicHashTable.awaitTermination(5, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

