/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.Validator;

public class CompoundValidator<T>
implements Validator<T> {
    private final List<Validator<T>> validatorList = new ArrayList<Validator<T>>();
    private Diagnostic maxDiagnostic = null;

    public CompoundValidator(Validator<T> ... validators) {
        if (validators != null) {
            this.validatorList.addAll(Arrays.asList(validators));
        }
    }

    public void addValidtor(Validator<T> validator) {
        this.validatorList.add(validator);
    }

    @Override
    public Diagnostic getDiagnostic() {
        return this.maxDiagnostic;
    }

    @Override
    public boolean isValid(T value) {
        this.maxDiagnostic = null;
        int maxError = 0;
        for (Validator<T> oneValidator : this.validatorList) {
            Diagnostic diagnostic;
            if (oneValidator.isValid(value) || (diagnostic = oneValidator.getDiagnostic()).getLevel() <= maxError) continue;
            this.maxDiagnostic = diagnostic;
            maxError = diagnostic.getLevel();
        }
        return this.maxDiagnostic == null;
    }
}

