/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations.forUML;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cte.ABCD.ABCDCloner;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.types.Union;
import org.cte.ABCD.transformations.forUML.GetReceiveBranchesInState;
import org.cte.ABCD.transformations.forUML.TInlineEventPool;

public class TInlineEventPoolReceive {
    private TInlineEventPool parentT;
    private SelectStmt topLevelSelect = null;

    public TInlineEventPoolReceive(TInlineEventPool parentT) {
        this.parentT = parentT;
    }

    public void runOn(Transition transition) throws Exception {
        Union vocabulary;
        Map<ReceiveStmt, GuardStmt> receive2guard = GetReceiveBranchesInState.run(transition);
        if (receive2guard.isEmpty()) {
            Port epPort = this.parentT.processOwnedEventPoolPort.get(transition.getParent());
            if (epPort == null) {
                return;
            }
            Type t = epPort.getType();
            while (t instanceof TypeDecl) {
                t = ((TypeDecl)t).getType();
            }
            vocabulary = (Union)t;
        } else {
            vocabulary = this.getVocabulary(receive2guard.keySet(), transition.getFrom().getName());
        }
        Set<Field> notUsedEvents = this.computeNotUsedEvents(vocabulary, receive2guard.keySet());
        transition.getBehavior().accept(new ABCDWalker(new ABCDVisitor.Stub(){

            @Override
            public void visitSelectStmt(SelectStmt stm) {
                TInlineEventPoolReceive.this.topLevelSelect = stm;
            }
        }));
        Builder builder = this.parentT.builder;
        if (this.topLevelSelect == null && !notUsedEvents.isEmpty()) {
            this.topLevelSelect = builder.select(transition.getBehavior());
            this.parentT.replacer.addReplacement(transition.getBehavior(), builder.block(this.topLevelSelect));
        }
        ParameterDecl eventPool = this.parentT.processOwnedEventPool.get(transition.getParent());
        FunctionCall deferFunctionCall = null;
        if (transition.getDeferredEventsCount() > 0) {
            String functionName = "processDeferred";
            Expression[] maskValues = this.prepareDeferMask(transition, receive2guard, vocabulary, builder);
            FunctionDecl defHandler = this.parentT.deferHandlerPerEventPoolType.get(eventPool.getType());
            deferFunctionCall = (FunctionCall)builder.functionCall(functionName, builder.argumentMap(defHandler.getParameters(0), builder.reference(eventPool)), builder.argumentMap(defHandler.getParameters(1), builder.arrayLiteral(maskValues)));
            deferFunctionCall.setFunctionDeclaration(defHandler);
        }
        for (Field field : notUsedEvents) {
            if (this.isDeferred(transition, field)) continue;
            Block stmt = builder.block(builder.caseStmt(builder.not(builder.empty(builder.reference(eventPool))), builder.caseItem((Expression)builder.literal(true), (Statement)builder.block(deferFunctionCall == null ? null : builder.assign(builder.reference(eventPool), deferFunctionCall), builder.caseStmt(builder.first(builder.reference(eventPool)), builder.caseItem((Expression)builder.unionLiteral(vocabulary, field.getName(), field.getType() == null ? null : builder.any()), builder.assign(builder.reference(eventPool), builder.dequeue(builder.reference(eventPool)))))))), builder.loopOn(transition));
            this.topLevelSelect.addStatements(stmt);
        }
        for (ReceiveStmt receive : receive2guard.keySet()) {
            Statement receiveBlock = builder.caseStmt(builder.first(builder.reference(eventPool)), builder.caseItem(receive.getExpression(), builder.assign(builder.reference(eventPool), builder.dequeue(builder.reference(eventPool)))));
            if (deferFunctionCall != null) {
                receiveBlock = builder.block(builder.assign(builder.reference(eventPool), deferFunctionCall), receiveBlock);
            }
            CaseStmt caseStmt = builder.caseStmt(builder.not(builder.empty(builder.reference(eventPool))), builder.caseItem((Expression)builder.literal(true), receiveBlock));
            this.parentT.replacer.addReplacement(receive, caseStmt);
        }
        for (ReceiveStmt rcv : receive2guard.keySet()) {
            GuardStmt guard = receive2guard.get(rcv);
            if (guard == null) continue;
            boolean isDeferrable = false;
            for (DeferredEvent deferrable : transition.getDeferredEventsList()) {
                String rL;
                String dL = deferrable.getEventType().getSelector();
                if (!dL.equals(rL = ((UnionLiteral)rcv.getExpression()).getSelector())) continue;
                isDeferrable = true;
                break;
            }
            CaseStmt caseStmt = builder.caseStmt(guard.getExpression(), builder.caseItem((Expression)builder.literal(true), builder.nullStmt()));
            if (!isDeferrable) {
                caseStmt.addItems(builder.caseItem((Expression)builder.literal(false), (Statement)builder.loopOn(transition)));
            }
            this.parentT.replacer.addReplacement(guard, caseStmt);
        }
        this.replaceGuardsWithoutTriggers(transition, new HashSet<GuardStmt>(receive2guard.values()));
        this.topLevelSelect = null;
    }

    private void replaceGuardsWithoutTriggers(Transition transition, final Set<GuardStmt> guardWithTriggers) throws Exception {
        transition.accept(new ABCDWalker(new ABCDVisitor.Stub(){

            @Override
            public void visitGuardStmt(GuardStmt guard) {
                if (!guardWithTriggers.contains(guard)) {
                    CaseStmt caseStmt = ((TInlineEventPoolReceive)TInlineEventPoolReceive.this).parentT.builder.caseStmt(guard.getExpression(), ((TInlineEventPoolReceive)TInlineEventPoolReceive.this).parentT.builder.caseItem((Expression)((TInlineEventPoolReceive)TInlineEventPoolReceive.this).parentT.builder.literal(true), ((TInlineEventPoolReceive)TInlineEventPoolReceive.this).parentT.builder.nullStmt()));
                    ((TInlineEventPoolReceive)TInlineEventPoolReceive.this).parentT.replacer.addReplacement(guard, caseStmt);
                }
            }
        }));
    }

    private Expression[] prepareDeferMask(Transition transition, Map<ReceiveStmt, GuardStmt> receive2guard, Union vocabulary, Builder builder) {
        Expression[] maskValues = new Expression[vocabulary.getFieldsCount()];
        for (int i = 0; i < vocabulary.getFieldsCount(); ++i) {
            boolean isDeferred = false;
            for (DeferredEvent dE : transition.getDeferredEventsList()) {
                if (!dE.getEventType().getSelector().equals(vocabulary.getFields(i).getName())) continue;
                isDeferred = true;
            }
            if (!isDeferred) {
                maskValues[i] = builder.literal(false);
                continue;
            }
            for (ReceiveStmt recv : receive2guard.keySet()) {
                UnionLiteral lit;
                if (!(recv.getExpression() instanceof UnionLiteral) || !(lit = (UnionLiteral)recv.getExpression()).getSelector().equals(vocabulary.getFields(i).getName())) continue;
                GuardStmt guard = receive2guard.get(recv);
                if (guard != null) {
                    maskValues[i] = builder.not(ABCDCloner.clone(guard.getExpression()));
                    continue;
                }
                maskValues[i] = builder.literal(false);
            }
            if (maskValues[i] != null) continue;
            maskValues[i] = isDeferred ? builder.literal(true) : builder.literal(false);
        }
        return maskValues;
    }

    private boolean isDeferred(Transition transition, Field field) {
        for (DeferredEvent dE : transition.getDeferredEventsList()) {
            if (!dE.getEventType().getSelector().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private Set<Field> computeNotUsedEvents(Union vocabulary, Set<ReceiveStmt> receives) {
        HashSet fields = new HashSet();
        HashMap<String, Field> name2field = new HashMap<String, Field>();
        for (Field f : vocabulary.getFieldsList()) {
            name2field.put(f.getName(), f);
        }
        for (ReceiveStmt receive : receives) {
            if (!(receive.getExpression() instanceof UnionLiteral)) continue;
            UnionLiteral lit = (UnionLiteral)receive.getExpression();
            fields.add(name2field.get(lit.getSelector()));
        }
        HashSet<Field> result = new HashSet<Field>(vocabulary.getFieldsList());
        result.removeAll(fields);
        return result;
    }

    private Union getVocabulary(Set<ReceiveStmt> receptions, String stateName) throws Exception {
        Port port = null;
        for (ReceiveStmt reception : receptions) {
            if (port == null) {
                port = reception.getPort();
                continue;
            }
            if (port == reception.getPort()) continue;
            throw new Exception("More than one event pool used in state: " + stateName);
        }
        Type t = port.getType();
        while (t instanceof TypeDecl) {
            t = ((TypeDecl)t).getType();
        }
        if (!(t instanceof Union)) {
            throw new Exception("Unsupported type for port '" + port.getName() + "' (should be union type)");
        }
        return (Union)t;
    }
}

