/*
 * Decompiled with CFR 0.152.
 */
package obp.obs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.obs.ObsVisitor;
import obp.obs.Transition;
import obp.obs.Type;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class State
implements BoostObject {
    private String name;
    private Type type;
    private final List<Transition> inTransitionList = new ArrayList<Transition>();
    private final List<Transition> outTransitionList = new ArrayList<Transition>();

    public State() {
    }

    protected State(Boost boost) {
        boost.register((BoostObject)this);
        this.name = boost.readString();
        this.type = (Type)boost.readEnum(Type.class);
        for (Transition oneChild : BoostUtil.readObjectList((Boost)boost, Transition.class)) {
            this.inTransitionList.add(oneChild);
        }
        for (Transition oneChild : BoostUtil.readObjectList((Boost)boost, Transition.class)) {
            this.outTransitionList.add(oneChild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newValue) {
        if (this.type == null ? newValue != null : !this.type.equals((Object)newValue)) {
            this.type = newValue;
        }
    }

    public List<Transition> getInTransitionList() {
        return Collections.unmodifiableList(this.inTransitionList);
    }

    public int getInTransitionCount() {
        return this.inTransitionList.size();
    }

    public Transition getInTransition(int index) {
        if (index < 0 || index >= this.getInTransitionCount()) {
            return null;
        }
        return this.inTransitionList.get(index);
    }

    public void addInTransition(Transition newValue) {
        this.addInTransition(this.getInTransitionCount(), newValue);
    }

    public void addInTransition(int index, Transition newValue) {
        this.inTransitionList.add(index, newValue);
    }

    public Transition setInTransition(int index, Transition newValue) {
        return this.inTransitionList.set(index, newValue);
    }

    public void addAllInTransition(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addInTransition(this.getInTransitionCount(), newValue);
        }
    }

    public void removeInTransition(Transition value) {
        int index = this.inTransitionList.indexOf(value);
        if (index >= 0) {
            this.removeInTransition(index);
        }
    }

    public void removeInTransition(int index) {
        this.inTransitionList.remove(index);
    }

    public void addInTransitionAndOpposite(Transition newValue) {
        this.addInTransition(newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
    }

    public void addAllInTransitionAndOpposite(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addInTransitionAndOpposite(this.getInTransitionCount(), newValue);
        }
    }

    public void addInTransitionAndOpposite(int index, Transition newValue) {
        this.addInTransition(index, newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
    }

    public Transition setInTransitionAndOpposite(int index, Transition newValue) {
        Transition oldValue = this.inTransitionList.set(index, newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
        return oldValue;
    }

    public void removeInTransitionAndOpposite(Transition removed) {
        this.removeInTransition(removed);
        if (removed != null) {
            removed.setTarget(null);
        }
    }

    public void removeInTransitionAndOpposite(int index) {
        Transition removed = this.inTransitionList.get(index);
        this.removeInTransition(index);
        if (removed != null) {
            removed.setTarget(null);
        }
    }

    public List<Transition> getOutTransitionList() {
        return Collections.unmodifiableList(this.outTransitionList);
    }

    public int getOutTransitionCount() {
        return this.outTransitionList.size();
    }

    public Transition getOutTransition(int index) {
        if (index < 0 || index >= this.getOutTransitionCount()) {
            return null;
        }
        return this.outTransitionList.get(index);
    }

    public void addOutTransition(Transition newValue) {
        this.addOutTransition(this.getOutTransitionCount(), newValue);
    }

    public void addOutTransition(int index, Transition newValue) {
        this.outTransitionList.add(index, newValue);
    }

    public Transition setOutTransition(int index, Transition newValue) {
        return this.outTransitionList.set(index, newValue);
    }

    public void addAllOutTransition(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addOutTransition(this.getOutTransitionCount(), newValue);
        }
    }

    public void removeOutTransition(Transition value) {
        int index = this.outTransitionList.indexOf(value);
        if (index >= 0) {
            this.removeOutTransition(index);
        }
    }

    public void removeOutTransition(int index) {
        this.outTransitionList.remove(index);
    }

    public void addOutTransitionAndOpposite(Transition newValue) {
        this.addOutTransition(newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
    }

    public void addAllOutTransitionAndOpposite(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addOutTransitionAndOpposite(this.getOutTransitionCount(), newValue);
        }
    }

    public void addOutTransitionAndOpposite(int index, Transition newValue) {
        this.addOutTransition(index, newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
    }

    public Transition setOutTransitionAndOpposite(int index, Transition newValue) {
        Transition oldValue = this.outTransitionList.set(index, newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
        return oldValue;
    }

    public void removeOutTransitionAndOpposite(Transition removed) {
        this.removeOutTransition(removed);
        if (removed != null) {
            removed.setSource(null);
        }
    }

    public void removeOutTransitionAndOpposite(int index) {
        Transition removed = this.outTransitionList.get(index);
        this.removeOutTransition(index);
        if (removed != null) {
            removed.setSource(null);
        }
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.name);
        boost.writeEnum((Enum)this.type);
        BoostUtil.writeObjectCollection((Boost)boost, this.inTransitionList);
        BoostUtil.writeObjectCollection((Boost)boost, this.outTransitionList);
    }

    public void accept(ObsVisitor visitor) {
        visitor.visitState(this);
    }
}

