/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.explorer.ConfsFileHandler;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.obs.Action;

public class ConfsFile2MTX
extends ConfsFileHandler {
    BufferedWriter matrixBW;
    final File tmpFile = File.createTempFile("matrixmarket_tmp", ".mttx");
    int x = 0;

    public ConfsFile2MTX(ExplorerResult explorerResult) throws Exception {
        super(explorerResult);
        this.matrixBW = new BufferedWriter(new FileWriter(this.tmpFile), 4056);
    }

    public ConfsFile2MTX(ProgramLoader programLoader, File resultFile) throws Exception {
        super(programLoader, resultFile);
        this.matrixBW = new BufferedWriter(new FileWriter(this.tmpFile));
    }

    public ConfsFile2MTX(ProgramLoader programLoader, ConcreteContext context, File ccslFile, File resultFile) throws Exception {
        super(programLoader, context, ccslFile, resultFile);
        this.matrixBW = new BufferedWriter(new FileWriter(this.tmpFile));
    }

    @Override
    void doOnConfiguration(Configuration conf, List<Action> newActions) {
        if (this.x % 10000 == 0) {
            System.out.println("INFO: Read " + this.x + " configurations");
        }
        ++this.x;
        if (this.matrixBW == null) {
            return;
        }
        for (Action act : newActions) {
            try {
                this.matrixBW.write(conf.id + 1 + " " + (act.targetId + 1) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void toMatrixMarket(File file) {
        try {
            String line;
            for (Action act : this.lastReadActions) {
                this.matrixBW.write(this.lastReadConfiguration.id + 1 + " " + (act.targetId + 1) + "\n");
            }
            this.readAll();
            this.matrixBW.close();
            BufferedWriter mmFile = new BufferedWriter(new FileWriter(file));
            mmFile.write("%%MatrixMarket matrix coordinate pattern general\n");
            mmFile.write(this.getConfigurationCount() + " " + this.getConfigurationCount() + " " + this.getActionCount() + "\n");
            BufferedReader tmp = new BufferedReader(new FileReader(this.tmpFile));
            while ((line = tmp.readLine()) != null) {
                mmFile.write(line + "\n");
            }
            mmFile.close();
            tmp.close();
            System.out.println("INFO: Finished reading " + this.x + " configurations");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        super.close();
        this.tmpFile.delete();
    }
}

