/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.LTL.model.Atom;
import obp.LTL.model.AtomReference;
import obp.LTL.model.Conjunction;
import obp.LTL.model.Disjunction;
import obp.LTL.model.Equivalence;
import obp.LTL.model.Eventually;
import obp.LTL.model.Expression;
import obp.LTL.model.FormulaDeclaration;
import obp.LTL.model.FormulaReference;
import obp.LTL.model.Globally;
import obp.LTL.model.Implication;
import obp.LTL.model.Negation;
import obp.LTL.model.Next;
import obp.LTL.model.Release;
import obp.LTL.model.Until;
import obp.buchi.BuchiAutomaton;
import obp.buchi.State;
import obp.cdl.Activity;
import obp.cdl.ActivityDeclaration;
import obp.cdl.ActivityReference;
import obp.cdl.AltActivity;
import obp.cdl.Assignment;
import obp.cdl.AtomicGuard;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.ComposedGuard;
import obp.cdl.Declaration;
import obp.cdl.EventDeclaration;
import obp.cdl.EventReference;
import obp.cdl.Guard;
import obp.cdl.GuardOperator;
import obp.cdl.NullActivity;
import obp.cdl.Option;
import obp.cdl.ParActivity;
import obp.cdl.PredicateDeclaration;
import obp.cdl.ProcessId;
import obp.cdl.PropertyDeclaration;
import obp.cdl.PropertyReference;
import obp.cdl.RestrictionDeclaration;
import obp.cdl.RestrictionReference;
import obp.cdl.SeqActivity;
import obp.cdl.VariableDeclaration;
import obp.cdl.VariableReference;
import obp.event.Event;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Message;
import obp.event.Output;
import obp.event.PredicateEvent;
import obp.event.Signal;
import obp.event.Synchronous;
import obp.event.Value;
import obp.literal.AnyLiteral;
import obp.literal.ArrayLiteral;
import obp.literal.BooleanLiteral;
import obp.literal.ConstantReference;
import obp.literal.IntegerLiteral;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.RecordLiteral;
import obp.literal.StringLiteral;
import obp.literal.UnionLiteral;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.Transition;
import obp.obs.Type;
import obp.obs.When;
import obp.predicate.AllPredicate;
import obp.predicate.ArrayAccess;
import obp.predicate.AtomicAccess;
import obp.predicate.ComparisonOperator;
import obp.predicate.FieldAccess;
import obp.predicate.LiteralComparisonPredicate;
import obp.predicate.LiteralEqualityPredicate;
import obp.predicate.LogicOperator;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.predicate.PredicateReference;
import obp.predicate.StatePredicate;
import obp.predicate.SystemAccess;
import obp.predicate.VariableComparisonPredicate;
import obp.predicate.VariableEqualityPredicate;
import obp.property.Arity;
import obp.property.Immediacy;
import obp.property.Nullity;
import obp.property.NullityExpression;
import obp.property.Occurrence;
import obp.property.OccurrenceEvent;
import obp.property.OccurrenceExpression;
import obp.property.Precedency;
import obp.property.PrecedencyExpression;
import obp.property.Property;
import obp.property.PropertyAbsence;
import obp.property.PropertyBuchi;
import obp.property.PropertyExistence;
import obp.property.PropertyObserver;
import obp.property.PropertyPrecedence;
import obp.property.PropertyResponse;
import obp.property.Scope;
import obp.property.TempGuard;
import obp.property.TemporalOperator;
import obp.property.TimeConstrain;
import obp.util.EventUtil;

public class CDLParserHelper {
    private static final String StartName = "start";
    private static final String RejectName = "reject";
    private static final String SuccessName = "success";
    private static final String CutName = "cut";
    private Map<String, obp.obs.State> observerStateMap = new HashMap<String, obp.obs.State>();
    private Map<String, State> buchiStateMap = new HashMap<String, State>();
    FormulaDeclaration ltlContext;

    public CDLUnit createCdlUnit(List<Declaration> declarations) {
        CDLUnit unit = new CDLUnit();
        for (Declaration declaration : declarations) {
            unit.addDeclaration(0, declaration);
        }
        return unit;
    }

    public CDLDeclaration createCdlDeclaration(String name, List<String> ltlNames, List<String> restrictionNames, List<String> propertyNames, List<Predicate> asserts, Predicate foldingPredicate, Activity init, ParActivity main, List<Option> options) {
        CDLDeclaration cdl = new CDLDeclaration();
        cdl.setName(name);
        cdl.setInit(init);
        cdl.setMain(main);
        if (ltlNames != null) {
            for (String ltlName : ltlNames) {
                cdl.addLtl(this.createLtlFormulaReference(ltlName));
            }
        }
        if (restrictionNames != null) {
            for (String restrictionName : restrictionNames) {
                cdl.addRestriction(this.createRestrictionReference(restrictionName));
            }
        }
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                cdl.addProperty(this.createPropertyReference(propertyName));
            }
        }
        if (asserts != null) {
            for (Predicate azzert : asserts) {
                cdl.addAssert(azzert);
            }
        }
        if (options != null) {
            for (Option option : options) {
                cdl.addOption(option);
            }
        }
        if (foldingPredicate != null) {
            cdl.setFoldingPredicate(foldingPredicate);
        }
        return cdl;
    }

    public VariableDeclaration createVariableDeclaration(String name, List<String> values) {
        VariableDeclaration result = new VariableDeclaration();
        result.setName(name);
        for (String value : values) {
            result.addValue(value);
        }
        return result;
    }

    public EventDeclaration createEventDeclaration(String name, Event event) {
        EventDeclaration result = new EventDeclaration();
        result.setName(name);
        result.setIs(event);
        return result;
    }

    public PropertyDeclaration createPropertyDeclaration(String name, Property property) {
        PropertyDeclaration result = new PropertyDeclaration();
        result.setName(name);
        result.setIs(property);
        if (property instanceof PropertyObserver) {
            for (obp.obs.State state : ((PropertyObserver)property).getObserver().getStateList()) {
                if (state.getType() != Type.Cut) continue;
                throw new IllegalArgumentException("Property '" + name + "' contains a 'cut' state (not allowed).");
            }
        }
        return result;
    }

    public RestrictionDeclaration createRestrictionDeclaration(String name, Property property) {
        RestrictionDeclaration result = new RestrictionDeclaration();
        result.setName(name);
        result.setIs(property);
        if (property instanceof PropertyObserver) {
            for (obp.obs.State state : ((PropertyObserver)property).getObserver().getStateList()) {
                if (state.getType() != Type.Success && state.getType() != Type.Reject) continue;
                throw new IllegalArgumentException("Restriction '" + name + "' contains a 'success' or 'reject' states.(not allowed).");
            }
        } else {
            throw new IllegalArgumentException("Restriction '" + name + "' contains a pattern (not supported).");
        }
        return result;
    }

    public PredicateDeclaration createPredicateDeclaration(String name, Predicate predicate) {
        PredicateDeclaration result = new PredicateDeclaration();
        result.setName(name);
        result.setIs(predicate);
        return result;
    }

    public ActivityDeclaration createActivityDeclaration(String name, Activity activity) {
        ActivityDeclaration result = new ActivityDeclaration();
        result.setName(name);
        result.setIs(activity);
        return result;
    }

    public void updateOption(Activity activity, List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                activity.addOption(option);
            }
        }
    }

    private void initActivity(Activity activity) {
        activity.setLoop(1);
        activity.setAtomic(false);
    }

    public ParActivity createParActivity(List<Activity> children) {
        ParActivity activity = new ParActivity();
        this.initActivity(activity);
        for (Activity reference : children) {
            activity.addActivity(reference);
        }
        return activity;
    }

    public SeqActivity createSeqActivity(Activity one) {
        SeqActivity seq = new SeqActivity();
        this.initActivity(seq);
        seq.addActivity(one);
        return seq;
    }

    public SeqActivity createSeqActivity(Activity one, Activity two) {
        SeqActivity seq = new SeqActivity();
        this.initActivity(seq);
        seq.addActivity(one);
        seq.addActivity(two);
        return seq;
    }

    public SeqActivity addActivityToSeqActivity(SeqActivity seq, Activity next) {
        seq.addActivity(next);
        return seq;
    }

    public AltActivity createAltActivity(Guard guardOne, Activity one, Guard guardTwo, Activity two) {
        AltActivity alt = new AltActivity();
        this.initActivity(alt);
        alt.addGuard(guardOne);
        alt.addActivity(one);
        alt.addGuard(guardTwo);
        alt.addActivity(two);
        return alt;
    }

    public AltActivity addActivityToAltActivity(AltActivity alt, Guard guard, Activity next) {
        alt.addGuard(guard);
        alt.addActivity(next);
        return alt;
    }

    public Assignment createAssignment(String variable, String value) {
        Assignment assignment = new Assignment();
        assignment.setVariable(this.createVariableReference(variable));
        assignment.setValue(value);
        return assignment;
    }

    public NullActivity createNullActivity() {
        return new NullActivity();
    }

    public EventReference createAnonymousEvent(Event is) {
        return EventUtil.createAnonymousEventReference(is);
    }

    public ComposedGuard createAndGuard(Guard left, Guard right) {
        ComposedGuard guard = new ComposedGuard();
        guard.setOperator(GuardOperator.AND);
        guard.addChild(left);
        guard.addChild(right);
        return guard;
    }

    public ComposedGuard createOrGuard(Guard left, Guard right) {
        ComposedGuard guard = new ComposedGuard();
        guard.setOperator(GuardOperator.OR);
        guard.addChild(left);
        guard.addChild(right);
        return guard;
    }

    public ComposedGuard createNotGuard(Guard child) {
        ComposedGuard guard = new ComposedGuard();
        guard.setOperator(GuardOperator.NOT);
        guard.addChild(child);
        return guard;
    }

    public AtomicGuard createAtomicGuard(String left, String right) {
        AtomicGuard guard = new AtomicGuard();
        guard.setLeft(left);
        guard.setRight(right);
        return guard;
    }

    public void updateOption(Event event, List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                event.addOption(option);
            }
        }
    }

    public Output createOutput(Message message, ProcessId from, ProcessId to) {
        if (!(message instanceof Value)) {
            throw new IllegalArgumentException("Signals aren't supported in asynchronous communication.");
        }
        Output output = new Output();
        output.setMessage((Value)message);
        output.setFrom(from);
        output.setTo(to);
        return output;
    }

    public Input createInput(Message message, ProcessId from, ProcessId to) {
        if (!(message instanceof Value)) {
            throw new IllegalArgumentException("Signals aren't supported in asynchronous communication.");
        }
        Input input = new Input();
        input.setMessage((Value)message);
        input.setFrom(from);
        input.setTo(to);
        return input;
    }

    public Synchronous createSynchronous(Message message, ProcessId from, ProcessId to) {
        if (!(message instanceof Signal)) {
            throw new IllegalArgumentException("Values aren't supported in synchronous communication.");
        }
        Synchronous sync = new Synchronous();
        sync.setMessage((Signal)message);
        sync.setFrom(from);
        sync.setTo(to);
        return sync;
    }

    public Informal createInformal(String tag, ProcessId from) {
        Informal informal = new Informal();
        informal.setTag(tag);
        informal.setFrom(from);
        return informal;
    }

    public PredicateEvent createPredicateEvent(Predicate predicate, boolean value) {
        PredicateEvent event = new PredicateEvent();
        if (!value) {
            predicate = this.createNotPredicate(predicate);
        }
        event.setPredicate(predicate);
        return event;
    }

    public Signal createSignal(ProcessId pid, String name, List<Literal> arguments) {
        Signal signal = new Signal();
        signal.setPid(pid);
        signal.setName(name);
        if (arguments != null) {
            for (Literal argument : arguments) {
                signal.addArgument(argument);
            }
        }
        return signal;
    }

    public Value createValue(Literal literal) {
        Value value = new Value();
        value.setLiteral(literal);
        return value;
    }

    public void updateOption(Predicate predicate, List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                predicate.addOption(option);
            }
        }
    }

    public LogicPredicate createAndPredicate(Predicate left, Predicate right) {
        LogicPredicate predicate = new LogicPredicate();
        predicate.setOperator(LogicOperator.AND);
        predicate.setLeft(left);
        predicate.setRight(right);
        return predicate;
    }

    public LogicPredicate createOrPredicate(Predicate left, Predicate right) {
        LogicPredicate predicate = new LogicPredicate();
        predicate.setOperator(LogicOperator.OR);
        predicate.setLeft(left);
        predicate.setRight(right);
        return predicate;
    }

    public LogicPredicate createNotPredicate(Predicate child) {
        LogicPredicate predicate = new LogicPredicate();
        predicate.setOperator(LogicOperator.NOT);
        predicate.setLeft(child);
        return predicate;
    }

    public StatePredicate createStatePredicate(ProcessId pid, String state) {
        StatePredicate statePredicate = new StatePredicate();
        statePredicate.setPid(pid);
        statePredicate.setState(state);
        return statePredicate;
    }

    public VariableComparisonPredicate createVariableComparisonPredicate(SystemAccess left, ComparisonOperator operator, SystemAccess right) {
        VariableComparisonPredicate predicate = new VariableComparisonPredicate();
        predicate.setLeft(left);
        predicate.setOperator(operator);
        predicate.setRight(right);
        return predicate;
    }

    public LiteralComparisonPredicate createLiteralComparisonPredicate(SystemAccess left, ComparisonOperator operator, Literal right) {
        LiteralComparisonPredicate predicate = new LiteralComparisonPredicate();
        predicate.setLeft(left);
        predicate.setOperator(operator);
        predicate.setRight(right);
        return predicate;
    }

    public VariableEqualityPredicate createVariableEqualityPredicate(SystemAccess left, SystemAccess right) {
        VariableEqualityPredicate variablePredicate = new VariableEqualityPredicate();
        variablePredicate.setLeft(left);
        variablePredicate.setRight(right);
        return variablePredicate;
    }

    public LiteralEqualityPredicate createLiteralEqualityPredicate(SystemAccess left, Literal right) {
        LiteralEqualityPredicate variablePredicate = new LiteralEqualityPredicate();
        variablePredicate.setLeft(left);
        variablePredicate.setRight(right);
        return variablePredicate;
    }

    public SystemAccess createSystemAccess(ProcessId pid, List<AtomicAccess> accessList) {
        SystemAccess address = new SystemAccess();
        address.setPid(pid);
        for (AtomicAccess access : accessList) {
            address.addAccess(access);
        }
        return address;
    }

    public AllPredicate createAllPredicate() {
        return new AllPredicate();
    }

    public FieldAccess createFieldAccess(String name) {
        FieldAccess result = new FieldAccess();
        result.setName(name);
        return result;
    }

    public ArrayAccess createArrayAccess(String name, int index) {
        ArrayAccess result = new ArrayAccess();
        result.setName(name);
        result.setIndex(index);
        return result;
    }

    public void updateOption(Property property, List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                property.addOption(option);
            }
        }
    }

    public void updateScope(Property property, Scope scope) {
        property.setScope(scope);
    }

    public PropertyPrecedence createPropertyPrecedence(TempGuard time, Immediacy immediacity, boolean repeatibility, OccurrenceExpression olePre, OccurrenceExpression olePost, List<NullityExpression> nec, List<PrecedencyExpression> pel) {
        PropertyPrecedence propertyPrecedence = new PropertyPrecedence();
        propertyPrecedence.setTemporalOperator(this.createTemporalOperator(time, immediacity));
        propertyPrecedence.setPreExpression(olePre);
        propertyPrecedence.setPostExpression(olePost);
        for (NullityExpression nullityExpression : nec) {
            propertyPrecedence.addNullityExpression(nullityExpression);
        }
        for (PrecedencyExpression precedencyExpression : pel) {
            propertyPrecedence.addPrecedencyExpression(precedencyExpression);
        }
        propertyPrecedence.setRepeatability(repeatibility);
        return propertyPrecedence;
    }

    public PropertyResponse createPropertyResponse(TempGuard time, Immediacy immediacy, boolean repeatibility, OccurrenceExpression olePre, OccurrenceExpression olePost, List<NullityExpression> nec, List<PrecedencyExpression> pel) {
        PropertyResponse propertyResponse = new PropertyResponse();
        propertyResponse.setTemporalOperator(this.createTemporalOperator(time, immediacy));
        propertyResponse.setPreExpression(olePre);
        propertyResponse.setPostExpression(olePost);
        for (NullityExpression nullityExpression : nec) {
            propertyResponse.addNullityExpression(nullityExpression);
        }
        for (PrecedencyExpression precedencyExpression : pel) {
            propertyResponse.addPrecedencyExpression(precedencyExpression);
        }
        propertyResponse.setRepeatability(repeatibility);
        return propertyResponse;
    }

    public PropertyAbsence createPropertyAbsence(OccurrenceExpression ole, TempGuard time, boolean repeatability) {
        PropertyAbsence propertyAbsence = new PropertyAbsence();
        propertyAbsence.setOccurrenceExpression(ole);
        propertyAbsence.setRepeatability(repeatability);
        propertyAbsence.setTempGuard(time);
        return propertyAbsence;
    }

    public PropertyExistence createPropertyExistence(OccurrenceExpression ole, TempGuard time, boolean repeatability) {
        PropertyExistence propertyAbsence = new PropertyExistence();
        propertyAbsence.setTempGuard(time);
        propertyAbsence.setOccurrenceExpression(ole);
        return propertyAbsence;
    }

    public TemporalOperator createTemporalOperator(TempGuard time, Immediacy immediacy) {
        TemporalOperator temporalOperator = new TemporalOperator();
        temporalOperator.setTempGuard(time);
        temporalOperator.setImmediacy(immediacy);
        return temporalOperator;
    }

    public TempGuard createTempGuard(TimeConstrain min, TimeConstrain max) {
        TempGuard tg = new TempGuard();
        tg.setMin(min);
        tg.setMax(max);
        return tg;
    }

    public TimeConstrain createTimeConstrain(int value, boolean strict) {
        TimeConstrain constrain = new TimeConstrain();
        constrain.setValue(value);
        constrain.setStrict(strict);
        return constrain;
    }

    public OccurrenceExpression createOccurrenceExpression(List<OccurrenceEvent> events, Occurrence occurrence) {
        OccurrenceExpression result = new OccurrenceExpression();
        result.setOccurrence(occurrence);
        for (OccurrenceEvent event : events) {
            result.addOccurrenceEvent(event);
        }
        return result;
    }

    public OccurrenceEvent createOccurrenceEvent(String name, Arity arity) {
        OccurrenceEvent result = new OccurrenceEvent();
        result.setArity(arity);
        result.setEvent(this.createEventReference(name));
        return result;
    }

    public NullityExpression createNullityExpression(String name, Nullity nullity) {
        NullityExpression result = new NullityExpression();
        result.setNullity(nullity);
        result.setEvent(this.createEventReference(name));
        return result;
    }

    public PrecedencyExpression createPrecedencyExpression(List<String> pre, Precedency precedency, List<String> post) {
        PrecedencyExpression result = new PrecedencyExpression();
        result.setPrecedency(precedency);
        for (String id : pre) {
            result.addPreEvent(this.createEventReference(id));
        }
        for (String id : post) {
            result.addPostEvent(this.createEventReference(id));
        }
        return result;
    }

    public Scope createScope(boolean strong, Predicate predicate) {
        Scope scope = new Scope();
        scope.setStrong(strong);
        scope.setPredicate(predicate);
        return scope;
    }

    private obp.obs.State getOrCreateState(String name) {
        obp.obs.State state = this.observerStateMap.get(name);
        if (state == null) {
            state = new obp.obs.State();
            state.setName(name);
            if (RejectName.equals(name)) {
                state.setType(Type.Reject);
            } else if (SuccessName.equals(name)) {
                state.setType(Type.Success);
            } else if (CutName.equals(name)) {
                state.setType(Type.Cut);
            } else {
                state.setType(Type.Normal);
            }
            this.observerStateMap.put(name, state);
        }
        return state;
    }

    private State getOrCreateBuchiState(String name) {
        State state = this.buchiStateMap.get(name);
        if (state == null) {
            state = new State();
            state.setName(name);
            this.buchiStateMap.put(name, state);
        }
        return state;
    }

    public PropertyObserver createPropertyObserver(String clock, List<Transition> transitions) {
        PropertyObserver property = new PropertyObserver();
        Observer observer = new Observer();
        property.setObserver(observer);
        observer.setClock(clock);
        for (obp.obs.State state : this.observerStateMap.values()) {
            observer.addState(state);
            if (!StartName.equals(state.getName())) continue;
            observer.setStartState(state);
        }
        for (Transition transition : transitions) {
            observer.addTransition(transition);
        }
        this.observerStateMap = new HashMap<String, obp.obs.State>();
        return property;
    }

    public PropertyObserver createSynchronousPropertyObserver(String clock, List<Transition> transitions) {
        PropertyObserver property = this.createPropertyObserver(clock, transitions);
        property.getObserver().setGreedy(false);
        return property;
    }

    public Transition createTransition(String source, When when, Predicate guard, List<EventReference> events, Reset reset, String target) {
        Transition transition = new Transition();
        transition.setSource(this.getOrCreateState(source));
        transition.setWhen(when);
        transition.setGuard(guard);
        if (events.get(0) != null) {
            transition.addAllEvents(events);
        }
        transition.setReset(reset);
        transition.setTarget(this.getOrCreateState(target));
        return transition;
    }

    public When createWhen(String clock, ComparisonOperator type, int value) {
        When when = new When();
        when.setClock(clock);
        when.setType(type);
        when.setValue(value);
        return when;
    }

    public Reset createReset(String clock, int value) {
        Reset reset = new Reset();
        reset.setClock(clock);
        reset.setValue(value);
        return reset;
    }

    public AnyLiteral createAnyLiteral() {
        return new AnyLiteral();
    }

    public IntegerLiteral createIntegerLiteral(int value) {
        IntegerLiteral literal = new IntegerLiteral();
        literal.setValue(value);
        return literal;
    }

    public BooleanLiteral createBooleanLiteral(boolean value) {
        BooleanLiteral literal = new BooleanLiteral();
        literal.setValue(value);
        return literal;
    }

    public StringLiteral createStringLiteral(String value) {
        StringLiteral literal = new StringLiteral();
        literal.setValue(value);
        return literal;
    }

    public ConstantReference createConstantReference(String name) {
        ConstantReference literal = new ConstantReference();
        literal.setName(name);
        return literal;
    }

    public ArrayLiteral createArrayLiteral(String typeName, List<Literal> valueList) {
        ArrayLiteral literal = new ArrayLiteral();
        literal.setTypeName(typeName);
        for (Literal value : valueList) {
            literal.addValue(value);
        }
        return literal;
    }

    public LiteralField createLiteralField(String name, Literal value) {
        LiteralField field = new LiteralField();
        field.setName(name);
        field.setValue(value);
        return field;
    }

    public RecordLiteral createRecordLiteral(String typeName, List<LiteralField> valuedFieldList) {
        RecordLiteral literal = new RecordLiteral();
        literal.setTypeName(typeName);
        for (LiteralField field : valuedFieldList) {
            literal.addField(field);
        }
        return literal;
    }

    public UnionLiteral createUnionLiteral(String typeName, String name, Literal value) {
        UnionLiteral literal = new UnionLiteral();
        literal.setTypeName(typeName);
        literal.setName(name);
        literal.setValue(value);
        return literal;
    }

    public FormulaReference createLtlFormulaReference(String name) {
        FormulaReference form = new FormulaReference();
        form.setName(name);
        return form;
    }

    public RestrictionReference createRestrictionReference(String name) {
        RestrictionReference reference = new RestrictionReference();
        reference.setName(name);
        return reference;
    }

    public PropertyReference createPropertyReference(String name) {
        PropertyReference reference = new PropertyReference();
        reference.setName(name);
        return reference;
    }

    public ProcessId createProcessId(String name, int id) {
        ProcessId processId = new ProcessId();
        processId.setName(name);
        processId.setId(id);
        return processId;
    }

    public ProcessId createEnvPid() {
        return this.createProcessId("env", 1);
    }

    public EventReference createEventReference(int loop, String name) {
        EventReference reference = new EventReference();
        reference.setLoop(loop);
        reference.setName(name);
        return reference;
    }

    public EventReference createEventReference(String name) {
        return this.createEventReference(-1, name);
    }

    public ActivityReference createActivityReference(int loop, String name) {
        ActivityReference reference = new ActivityReference();
        reference.setLoop(loop);
        reference.setName(name);
        return reference;
    }

    public ActivityReference createActivityReference(String name) {
        return this.createActivityReference(-1, name);
    }

    public VariableReference createVariableReference(String name) {
        VariableReference reference = new VariableReference();
        reference.setName(name);
        return reference;
    }

    public PredicateReference createPredicateReference(String name) {
        PredicateReference reference = new PredicateReference();
        reference.setName(name);
        return reference;
    }

    public Option createOption(String name, String value) {
        Option result = new Option();
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public FormulaDeclaration createLTLDeclaration(String name) {
        FormulaDeclaration result = new FormulaDeclaration();
        result.setName(name);
        this.ltlContext = result;
        return result;
    }

    public Expression createNext(Expression e) {
        Next exp = new Next();
        exp.setOperand(e);
        return exp;
    }

    public Expression createGlobally(Expression e) {
        Globally exp = new Globally();
        exp.setOperand(e);
        return exp;
    }

    public Expression createEventually(Expression e) {
        Eventually exp = new Eventually();
        exp.setOperand(e);
        return exp;
    }

    public Expression createNegation(Expression e) {
        Negation exp = new Negation();
        exp.setOperand(e);
        return exp;
    }

    public Expression createConjunction(Expression lhs, Expression rhs) {
        Conjunction exp = new Conjunction();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Expression createDisjunction(Expression lhs, Expression rhs) {
        Disjunction exp = new Disjunction();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Expression createImplication(Expression lhs, Expression rhs) {
        Implication exp = new Implication();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Expression createEquivalence(Expression lhs, Expression rhs) {
        Equivalence exp = new Equivalence();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Expression createRelease(Expression lhs, Expression rhs) {
        Release exp = new Release();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Expression createUntil(Expression lhs, Expression rhs) {
        Until exp = new Until();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public Object createAtom(String n) {
        PredicateReference pred = new PredicateReference();
        pred.setName(n);
        Atom atom = new Atom();
        atom.setIs(pred);
        return atom;
    }

    public Object createAtomReference(String n) {
        PredicateReference pred = new PredicateReference();
        pred.setName(n);
        Atom atom = new Atom();
        atom.setIs(pred);
        this.ltlContext.addAtoms(atom);
        AtomReference ref = new AtomReference();
        ref.setAtom(atom);
        return ref;
    }

    public FormulaDeclaration ltlContext() {
        return this.ltlContext;
    }

    public LogicPredicate createImplicationPredicate(Predicate l, Predicate r) {
        LogicPredicate predicate = new LogicPredicate();
        predicate.setOperator(LogicOperator.IMPLICATION);
        predicate.setLeft(l);
        predicate.setRight(r);
        return predicate;
    }

    public LogicPredicate createEquivalencePredicate(Predicate l, Predicate r) {
        LogicPredicate predicate = new LogicPredicate();
        predicate.setOperator(LogicOperator.EQUIVALENCE);
        predicate.setLeft(l);
        predicate.setRight(r);
        return predicate;
    }

    public PropertyBuchi createPropertyBuchi(List<String> accepting, String startName, List<obp.buchi.Transition> transitions) {
        PropertyBuchi pBuchi = new PropertyBuchi();
        BuchiAutomaton buchi = new BuchiAutomaton();
        pBuchi.setBuchi(buchi);
        for (String stateName : accepting) {
            State state = this.getOrCreateBuchiState(stateName);
            state.setAccepting(true);
        }
        buchi.addAllTransition(transitions);
        if (startName != null) {
            buchi.setStartState(this.getOrCreateBuchiState(startName));
        } else {
            for (State state : this.buchiStateMap.values()) {
                if (!StartName.equals(state.getName())) continue;
                buchi.setStartState(state);
            }
        }
        buchi.addAllState(this.buchiStateMap.values());
        if (buchi.getStartState() == null) {
            throw new IllegalArgumentException("Missing start state in buchi automata.");
        }
        this.buchiStateMap = new HashMap<String, State>();
        return pBuchi;
    }

    public obp.buchi.Transition createBuchiTransition(String source, Predicate guard, String target) {
        obp.buchi.Transition transition = new obp.buchi.Transition();
        transition.setSourceAndOpposite(this.getOrCreateBuchiState(source));
        transition.setGuard(guard);
        transition.setTargetAndOpposite(this.getOrCreateBuchiState(target));
        return transition;
    }
}

