/*
 * Decompiled with CFR 0.152.
 */
package obp.aut.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import obp.aut.Aut;
import obp.aut.Edge;

public class AutParser {
    private final BufferedReader reader;
    private Aut graph;

    public AutParser(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public Aut getGraph() {
        return this.graph;
    }

    protected void handleError(String message) throws Exception {
        throw new Exception(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws Exception {
        block22: {
            try {
                this.graph = new Aut();
                this.graph.setName("AutGraph");
                String header = this.reader.readLine().trim();
                if (!header.matches("^des\\([0-9]+,[0-9]+,[0-9]+\\)$")) {
                    this.handleError("Aut has wrong header.");
                    return;
                }
                String[] headers = header.substring(4, header.length() - 1).split(",");
                int transitionCount = Integer.parseInt(headers[1]);
                this.graph.setStateNumber(Integer.parseInt(headers[2]));
                int count = 0;
                String line = this.reader.readLine();
                while (line != null) {
                    String sourceString = null;
                    String labelString = null;
                    String targetString = null;
                    int firstColon = line.indexOf(44);
                    int lastColon = line.lastIndexOf(44);
                    int length = line.length();
                    sourceString = line.substring(1, firstColon);
                    labelString = line.substring(firstColon + 2, lastColon - 1);
                    targetString = line.substring(lastColon + 1, length - 1);
                    Edge edge = new Edge();
                    edge.setId(count++);
                    edge.setSource(Integer.parseInt(sourceString));
                    edge.setLabel(labelString.intern());
                    edge.setTarget(Integer.parseInt(targetString));
                    this.graph.addEdge(edge);
                    line = this.reader.readLine();
                }
                if (this.graph.getEdgeCount() == transitionCount) break block22;
                this.handleError("Wrong number of transitions");
            }
            catch (IOException e) {
                StringBuilder message = new StringBuilder();
                message.append("IO Error while reading ");
                message.append(e.getMessage());
                this.handleError(message.toString());
                break block22;
            }
            catch (Exception e) {
                StringBuilder message = new StringBuilder();
                message.append("Exception sended while reading (");
                message.append(e.getClass().getSimpleName());
                message.append("): ");
                message.append(e.getMessage());
                this.handleError(message.toString());
                break block22;
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (Exception e) {}
            }
            return;
        }
    }
}

