/*
 * Decompiled with CFR 0.152.
 */
package plug.language.explicit.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IFiredTransition;
import plug.language.explicit.model.ExplicitProgram;
import plug.language.explicit.runtime.ExplicitConfiguration;
import plug.statespace.transitions.FiredTransition;

public class ExplicitTransitionRelation
implements IConcurrentTransitionRelation<ExplicitTransitionRelation, ExplicitConfiguration, Integer> {
    public final String name;
    public final ExplicitProgram program;
    IAtomicPropositionsEvaluator<ExplicitConfiguration, Integer> evaluator = new IAtomicPropositionsEvaluator<ExplicitConfiguration, Integer>(){
        EqualityCondition[] atomicPropositionASTs;

        public int[] registerAtomicPropositions(String[] atomicPropositions) throws Exception {
            this.atomicPropositionASTs = new EqualityCondition[atomicPropositions.length];
            for (int i = 0; i < atomicPropositions.length; ++i) {
                this.atomicPropositionASTs[i] = this.parse(atomicPropositions[i]);
            }
            return new int[0];
        }

        public boolean[] getAtomicPropositionValuations(ExplicitConfiguration configuration) {
            boolean[] valuation = new boolean[this.atomicPropositionASTs.length];
            for (int i = 0; i < this.atomicPropositionASTs.length; ++i) {
                valuation[i] = configuration.values[ExplicitTransitionRelation.this.program.variables.get(this.atomicPropositionASTs[i].variable)] == this.atomicPropositionASTs[i].value;
            }
            return valuation;
        }

        public EqualityCondition parse(String code) {
            EqualityCondition condition = new EqualityCondition();
            StringTokenizer tokenizer = new StringTokenizer(code);
            condition.variable = tokenizer.nextToken();
            tokenizer.nextToken();
            condition.value = Integer.parseInt(tokenizer.nextToken());
            return condition;
        }

        class EqualityCondition {
            String variable;
            int value;

            EqualityCondition() {
            }
        }
    };

    public ExplicitTransitionRelation(String name, ExplicitProgram program) {
        this.name = name;
        this.program = program;
    }

    public ExplicitTransitionRelation createCopy() {
        return new ExplicitTransitionRelation(this.name, this.program);
    }

    public Set<ExplicitConfiguration> initialConfigurations() {
        HashSet<ExplicitConfiguration> initialSet = new HashSet<ExplicitConfiguration>();
        for (int i : this.program.initial) {
            ExplicitConfiguration config = new ExplicitConfiguration();
            config.id = i;
            config.values = this.program.states[i];
            initialSet.add(config);
        }
        return initialSet;
    }

    public Collection<Integer> fireableTransitionsFrom(ExplicitConfiguration source) {
        int[] fanout = this.program.getFireableTransitions(source.id);
        return Arrays.stream(fanout).boxed().collect(Collectors.toList());
    }

    public IFiredTransition<ExplicitConfiguration, ?> fireOneTransition(ExplicitConfiguration source, Integer transition) {
        ExplicitConfiguration target = new ExplicitConfiguration();
        target.id = transition;
        target.values = this.program.states[transition];
        return new FiredTransition((Object)source, (Object)target, (Object)transition);
    }

    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.evaluator;
    }
}

