/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.builder.ComplexBuilder;
import org.cte.ABCD.compiler.PrimitiveUtils;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.types.SemaphoreType;

public class TInlineSemaphore {
    private ABCDSystem currentSystem;
    private Builder builder;
    ComplexBuilder semBuilder;
    ChannelTypeDecl semChannelType;
    private Map<TypedElement, Port[]> semPortsMap = new LinkedHashMap<TypedElement, Port[]>();
    private Map<TypedElement, Map<ProcessInstance, List<ArgumentMap>>> semUsageMap = new LinkedHashMap<TypedElement, Map<ProcessInstance, List<ArgumentMap>>>();
    private Map<Point, ProcessDecl> sizeSemaphoreMap = new LinkedHashMap<Point, ProcessDecl>();

    public void runOn(ABCDSystem sys) throws Exception {
        this.currentSystem = sys;
        this.removeLocalSemaphores();
        this.removeUnusedSemaphores();
        this.builder = new Builder(sys.getCoreTypesList());
        this.semBuilder = new ComplexBuilder(sys.getCoreTypesList());
        this.inlineSemaphoreAttributes();
        this.computeUsageMap();
        this.inlineSharedSemaphores();
    }

    private void inlineSharedSemaphores() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        this.semChannelType = this.builder.syncChannelType("semInt", this.builder.intType());
        this.currentSystem.addChannelTypes(this.semChannelType);
        for (TypedElement sem : this.semUsageMap.keySet()) {
            Point clients = this.computeClients(sem);
            if (clients.x == 0 && clients.y == 0) continue;
            replacer.addRemove(sem);
            ProcessDecl semProcess = this.sizeSemaphoreMap.get(clients);
            if (semProcess == null) {
                semProcess = this.semBuilder.semaphore("sem_" + clients.x + "_" + clients.y, clients.x, clients.y);
                this.sizeSemaphoreMap.put(clients, semProcess);
            }
            ChannelDecl[] chans = this.createSemaphoreChannels(sem, clients);
            this.currentSystem.addAllChannels(Arrays.asList(chans));
            this.currentSystem.addCompositionAndOpposite(this.builder.instance(semProcess, chans, null, new Expression[]{((ValueHolder)sem).getValue()}));
            this.replaceSemaphoreBindings(sem, chans, clients, replacer);
        }
        this.currentSystem.addAllProcesses(this.sizeSemaphoreMap.values());
        this.currentSystem.accept(replacer);
    }

    private Point computeClients(TypedElement sem) {
        Map<ProcessInstance, List<ArgumentMap>> instancesMap = this.semUsageMap.get(sem);
        if (instancesMap == null) {
            return new Point(0, 0);
        }
        int psum = 0;
        int vsum = 0;
        for (List<ArgumentMap> args : instancesMap.values()) {
            for (ArgumentMap arg : args) {
                Port[] ports = this.semPortsMap.get(arg.getFormal());
                if (ports == null) continue;
                psum += ports[0] == null ? 0 : 1;
                vsum += ports[1] == null ? 0 : 1;
            }
        }
        return new Point(psum, vsum);
    }

    private ChannelDecl[] createSemaphoreChannels(TypedElement sem, Point clients) {
        int i;
        ChannelDecl[] chans = new ChannelDecl[clients.x + clients.y];
        NamedDeclaration mSem = sem instanceof NamedDeclaration ? (NamedDeclaration)((Object)sem) : null;
        for (i = 0; i < clients.x; ++i) {
            chans[i] = this.builder.syncChannel(mSem.getName() + "P" + i, this.semChannelType);
        }
        for (i = clients.x; i < clients.x + clients.y; ++i) {
            chans[i] = this.builder.syncChannel(mSem.getName() + "V" + i, this.semChannelType);
        }
        return chans;
    }

    private void replaceSemaphoreBindings(TypedElement sem, ChannelDecl[] chans, Point clients, ABCDReplacer replacer) {
        Map<ProcessInstance, List<ArgumentMap>> oldBindings = this.semUsageMap.get(sem);
        int pIdx = 0;
        int vIdx = clients.x;
        for (ProcessInstance instance : oldBindings.keySet()) {
            for (ArgumentMap arg : oldBindings.get(instance)) {
                replacer.addRemove(arg);
                Port[] ports = this.semPortsMap.get(arg.getFormal());
                if (ports == null) continue;
                if (ports[0] != null) {
                    instance.addOutputs(this.builder.portMap(ports[0], chans[pIdx++]));
                }
                if (ports[1] == null) continue;
                instance.addOutputs(this.builder.portMap(ports[1], chans[vIdx++]));
            }
        }
    }

    private void computeUsageMap() {
        List<VariableDecl> semaphores = this.sharedSemaphores();
        for (VariableDecl sem : semaphores) {
            this.semUsageMap.put(sem, new LinkedHashMap());
        }
        for (ProcessInstance instance : this.currentSystem.getCompositionList()) {
            instance.accept(new ABCDVisitor.Stub(){
                ProcessInstance currentInstance;
                ArgumentMap currentArgMap;

                @Override
                public void visitProcessInstance(ProcessInstance i) {
                    this.currentInstance = i;
                    for (ArgumentMap args : i.getArgumentsList()) {
                        args.accept(this);
                    }
                }

                @Override
                public void visitArgumentMap(ArgumentMap arg) {
                    this.currentArgMap = arg;
                    arg.getActual().accept(this);
                }

                @Override
                public void visitReference(Reference ref) {
                    ref.getRef().accept(this);
                }

                @Override
                public void visitVariableDecl(VariableDecl var) {
                    if (var.getType() instanceof SemaphoreType) {
                        Map semPerInstance = (Map)TInlineSemaphore.this.semUsageMap.get(var);
                        List args = (List)semPerInstance.get(this.currentInstance);
                        if (args == null) {
                            semPerInstance.put(this.currentInstance, Arrays.asList(this.currentArgMap));
                        } else {
                            args.add(this.currentArgMap);
                        }
                    }
                }
            });
        }
    }

    private List<VariableDecl> sharedSemaphores() {
        ArrayList<VariableDecl> list = new ArrayList<VariableDecl>();
        for (VariableDecl var : this.currentSystem.getVariablesList()) {
            if (!(var.getType() instanceof SemaphoreType)) continue;
            list.add(var);
        }
        return list;
    }

    private void inlineSemaphoreAttributes() {
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            int id = 1;
            for (TypedElement sem : PrimitiveUtils.semaphoreList(process)) {
                this.semPortsMap.put(sem, this.inlineSemaphoreIn(sem, id++, process));
            }
        }
    }

    private Port[] inlineSemaphoreIn(TypedElement sem, int id, ProcessDecl process) {
        List<SpecialTypeStmt> vList;
        ABCDReplacer repl = new ABCDReplacer();
        Port[] ports = new Port[2];
        List<SpecialTypeStmt> pList = PrimitiveUtils.POnSemaphore(sem, process);
        if (pList.size() > 0) {
            ports[0] = this.builder.port("sp" + id, this.builder.intType(), false);
            for (SpecialTypeStmt stm : pList) {
                OutputStmt p = stm.getArgumentsCount() == 0 ? this.builder.output(ports[0], this.builder.literal(1)) : this.builder.output(ports[0], stm.getArguments(0));
                repl.addReplacement(stm, p);
            }
            process.addPortsAndOpposite(ports[0]);
        }
        if ((vList = PrimitiveUtils.VOnSemaphore(sem, process)).size() > 0) {
            ports[1] = this.builder.port("sv" + id, this.builder.intType(), false);
            for (SpecialTypeStmt stm : vList) {
                OutputStmt v = stm.getArgumentsCount() == 0 ? this.builder.output(ports[1], this.builder.literal(1)) : this.builder.output(ports[1], stm.getArguments(0));
                repl.addReplacement(stm, v);
            }
            process.addPortsAndOpposite(ports[1]);
        }
        repl.addRemove(sem);
        process.accept(repl);
        return ports;
    }

    private void removeUnusedSemaphores() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            for (TypedElement sem : PrimitiveUtils.semaphoreList(process)) {
                List<SpecialTypeStmt> pList = PrimitiveUtils.POnSemaphore(sem, process);
                List<SpecialTypeStmt> vList = PrimitiveUtils.VOnSemaphore(sem, process);
                if (!pList.isEmpty() || !vList.isEmpty()) continue;
                replacer.addRemove(sem);
            }
        }
        this.currentSystem.accept(replacer);
    }

    private void removeLocalSemaphores() {
        ABCDReplacer replacer = new ABCDReplacer();
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            List<TypedElement> localM = this.localSemaphoreList(process);
            for (TypedElement semaphore : localM) {
                replacer.addRemove(semaphore);
                for (Statement statement : PrimitiveUtils.POnSemaphore(semaphore, process)) {
                    replacer.addRemove(statement);
                }
                for (Statement statement : PrimitiveUtils.VOnSemaphore(semaphore, process)) {
                    replacer.addRemove(statement);
                }
            }
        }
        this.currentSystem.accept(replacer);
    }

    private List<TypedElement> localSemaphoreList(final ProcessDecl process) {
        final ArrayList<TypedElement> semList = new ArrayList<TypedElement>();
        for (final TypedElement typedElement : process.getVariablesList()) {
            typedElement.accept(new ABCDVisitor.Stub(){

                @Override
                public void visitVariableDecl(VariableDecl toVisit) {
                    toVisit.getType().accept(this);
                }

                @Override
                public void visitSemaphoreType(SemaphoreType toVisit) {
                    semList.add(typedElement);
                    NamedDeclaration nE = typedElement instanceof NamedDeclaration ? (NamedDeclaration)((Object)typedElement) : null;
                    System.out.println("WARNING: local semaphore '" + nE.getName() + "' in process " + process.getName() + " will be removed");
                }
            });
        }
        return semList;
    }
}

