/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cdl.EventReference;
import obp.event.Event;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Message;
import obp.event.Output;
import obp.event.Value;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.ReferencedArgument;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.fiacre.ConcreteContextConfiguration;
import obp.explorer.runtime.fiacre.FiacreQueueUtil;
import obp.explorer.runtime.fiacre.LiteralToJavaObject;
import obp.explorer.runtime.fiacre.LiteralToMatcher;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.InformalAction;
import obp.explorer.runtime.util.NameUtil;
import obp.transfo.cc.ConcreteContextCache;
import obp.util.CDLUtil;
import org.xid.basics.serializer.Boost;

public class ConcreteContextBehavior
extends ProcessBehavior {
    private static final String startStateName = "start";
    private static final Pattern statePattern = Pattern.compile("s([0-9]+)");
    private final ConcreteContext cc;
    private Transition[][] transitions;
    private short rootId;

    public ConcreteContextBehavior(ConcreteContext cc, SymbolsTable symbols) throws Exception {
        super(CDLUtil.envName(), symbols);
        this.cc = cc;
    }

    @Override
    public int getStateId(String name) {
        if (startStateName.equals(name)) {
            return this.cc.getStateList().indexOf(this.cc.getStartState());
        }
        java.util.regex.Matcher matcher = statePattern.matcher(name);
        if (matcher.matches()) {
            return Integer.valueOf(matcher.group(1)) + 1;
        }
        throw new IllegalArgumentException("State '" + name + "' doesn't exist in process '" + this.name + "'.");
    }

    @Override
    public void link(ExplorationContext context, SymbolsTable symbols) {
        this.rootId = 0;
        if (this.cc == null || this.cc.getTransitionCount() == 0) {
            this.transitions = new Transition[1][];
            this.transitions[0] = new Transition[0];
        } else {
            try {
                int stateCount = this.cc.getStateCount();
                ConcreteContextCache cache = new ConcreteContextCache(this.cc);
                this.transitions = new Transition[stateCount][];
                for (int i = 0; i < stateCount; ++i) {
                    ArrayList<Transition> explorerTransitionList = new ArrayList<Transition>();
                    ArrayList<obp.cc.Transition> ccInputTransitions = new ArrayList<obp.cc.Transition>();
                    List<obp.cc.Transition> ccTransitions = cache.getOutTransitions(this.cc.getState(i));
                    if (ccTransitions != null) {
                        for (obp.cc.Transition ccTransition : ccTransitions) {
                            if (this.isInputTransition(ccTransition)) {
                                ccInputTransitions.add(ccTransition);
                                continue;
                            }
                            explorerTransitionList.add(this.createNotInputTransition(context, symbols, ccTransition));
                        }
                        Transition inputTransition = this.createInputTransition(context, symbols, this.cc.getState(i), ccInputTransitions);
                        if (inputTransition != null) {
                            explorerTransitionList.add(inputTransition);
                        }
                        this.transitions[i] = explorerTransitionList.toArray(new Transition[explorerTransitionList.size()]);
                        continue;
                    }
                    this.transitions[i] = new Transition[0];
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
        return ConcreteContextConfiguration.create(this.cc.getStateList().indexOf(this.cc.getStartState()));
    }

    @Override
    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        ConcreteContextConfiguration concreteContextConfiguration = (ConcreteContextConfiguration)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("context: '" + this.name + "'");
        text.append(" [@");
        if (this.cc.getState(concreteContextConfiguration.getState()) == this.cc.getStartState()) {
            text.append(startStateName);
        } else {
            text.append("s");
            text.append(concreteContextConfiguration.getState() + 1);
        }
        text.append("]");
        return text.toString();
    }

    @Override
    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return this.toStringConfiguration(behaviorConfiguration);
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        return ConcreteContextConfiguration.create(boost.readInt());
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
        ConcreteContextConfiguration me = (ConcreteContextConfiguration)processConfiguration;
        boost.writeInt(me.getState());
    }

    @Override
    public Transition[] getTransitions(Configuration configuration) {
        ConcreteContextConfiguration concreteContextConfiguration = (ConcreteContextConfiguration)configuration.behaviorConfigurations[this.id];
        return this.transitions[concreteContextConfiguration.getState()];
    }

    private boolean isInputTransition(obp.cc.Transition ccTransition) {
        EventReference action = ccTransition.getAction();
        return action != null && action.getReference().getIs() instanceof Input;
    }

    private Transition createNotInputTransition(ExplorationContext context, SymbolsTable symbols, obp.cc.Transition ccTransition) throws Exception {
        int source = this.cc.getStateList().indexOf(ccTransition.getSource());
        int target = this.cc.getStateList().indexOf(ccTransition.getTarget());
        if (ccTransition.getAction() != null) {
            Event event = ccTransition.getAction().getReference().getIs();
            if (event instanceof Output) {
                Output output = (Output)event;
                Object value = this.getMessageValue(output.getMessage(), context);
                String queueName = CDLUtil.toQueueName(output.getTo());
                try {
                    ProcessBehavior rootBehavior = (ProcessBehavior)context.getBehavior(this.rootId);
                    Class<?> rootType = rootBehavior.getClass();
                    Method method = rootType.getDeclaredMethod("get" + NameUtil.capName(queueName) + "Ref", new Class[0]);
                    ReferencedArgument queueObject = (ReferencedArgument)method.invoke((Object)rootBehavior, new Object[0]);
                    Class fieldType = queueObject.getArgumentType();
                    int queue_size = context.getProgram().getIoQueueSize(queueName);
                    if (fieldType == boolean[].class) {
                        ReferencedArgument queue = queueObject;
                        boolean booleanValue = (Boolean)value;
                        return this.createOutputBooleanSignalTransition(source, target, queue, queue_size, booleanValue);
                    }
                    if (fieldType == int[].class || fieldType == short[].class) {
                        ReferencedArgument queue = queueObject;
                        int intValue = (Integer)value;
                        return this.createOutputIntSignalTransition(source, target, queue, queue_size, intValue);
                    }
                    ReferencedArgument queue = queueObject;
                    return this.createOutputObjectSignalTransition(source, target, queue, queue_size, value);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Queue named '" + queueName + "' doesn't exist in root component.");
                }
            }
            if (event instanceof Informal) {
                String tag = ((Informal)event).getTag();
                short informalId = this.getOrCreateInformalId(tag, symbols);
                return this.createInformalTransition(source, target, informalId);
            }
            throw new IllegalArgumentException("Event named '" + event.getName() + "' isn't a valid CDL expression.");
        }
        return this.createEmptyTransition(source, target);
    }

    private Transition createEmptyTransition(final int source, final int target) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, target);
                return true;
            }
        };
    }

    private Transition createOutputBooleanSignalTransition(final int source, final int target, final ReferencedArgument<boolean[]> queue, final int queue_size, final boolean signalValue) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((boolean[])queue.get(configuration)).length < queue_size;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                queue.set(configuration, FiacreQueueUtil.enqueue(ConcreteContextBehavior.this.id, (boolean[])queue.get(configuration), signalValue, actions2));
                ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, target);
                return true;
            }
        };
    }

    private Transition createOutputIntSignalTransition(final int source, final int target, final ReferencedArgument<int[]> queue, final int queue_size, final int signalValue) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((int[])queue.get(configuration)).length < queue_size;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                queue.set(configuration, FiacreQueueUtil.enqueue(ConcreteContextBehavior.this.id, (int[])queue.get(configuration), signalValue, actions2));
                ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, target);
                return true;
            }
        };
    }

    private Transition createOutputObjectSignalTransition(final int source, final int target, final ReferencedArgument<Object[]> queue, final int queue_size, final Object signalValue) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((Object[])queue.get(configuration)).length < queue_size;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                queue.set(configuration, FiacreQueueUtil.enqueue(ConcreteContextBehavior.this.id, (Object[])queue.get(configuration), signalValue, actions2));
                ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, target);
                return true;
            }
        };
    }

    private Transition createInformalTransition(final int source, final int target, short informalId) {
        final InformalAction informal = new InformalAction(this.id, informalId);
        return new Transition(this.id){

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                actions2.add(informal);
                ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, target);
                return true;
            }
        };
    }

    private Transition createInputTransition(ExplorationContext context, SymbolsTable symbols, State sourceState, List<obp.cc.Transition> ccTransitions) throws Exception {
        context.getProgram().getIoQueueSize("toContext");
        LinkedHashMap<Matcher, Integer> signalToState = new LinkedHashMap<Matcher, Integer>();
        int source = this.cc.getStateList().indexOf(sourceState);
        for (obp.cc.Transition ccTransition : ccTransitions) {
            int target = this.cc.getStateList().indexOf(ccTransition.getTarget());
            Input input = (Input)ccTransition.getAction().getReference().getIs();
            Matcher messageMatcher = this.getMessageMatcher(input.getMessage(), context);
            signalToState.put(messageMatcher, target);
        }
        ProcessBehavior rootBehavior = (ProcessBehavior)context.getBehavior(this.rootId);
        Class<?> rootType = rootBehavior.getClass();
        try {
            Method method = rootType.getDeclaredMethod("get" + NameUtil.capName("toContext") + "Ref", new Class[0]);
            ReferencedArgument queueObject = (ReferencedArgument)method.invoke((Object)rootBehavior, new Object[0]);
            Class fieldType = queueObject.getArgumentType();
            if (fieldType == int[].class || fieldType == short[].class) {
                ReferencedArgument queue = queueObject;
                return this.createInputIntSignalTransition(source, queue, signalToState);
            }
            if (fieldType == boolean[].class) {
                ReferencedArgument queue = queueObject;
                return this.createInputBooleanSignalTransition(source, queue, signalToState);
            }
            ReferencedArgument queue = queueObject;
            return this.createInputObjectSignalTransition(source, queue, signalToState);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Transition createInputIntSignalTransition(final int source, final ReferencedArgument<int[]> queue, final LinkedHashMap<Matcher, Integer> signalToState) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((int[])queue.get(configuration)).length > 0;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                int[] currentQueue = (int[])queue.get(configuration);
                int received = FiacreQueueUtil.first(currentQueue);
                queue.set(configuration, FiacreQueueUtil.dequeue(ConcreteContextBehavior.this.id, currentQueue, actions2));
                for (Map.Entry entry : signalToState.entrySet()) {
                    try {
                        if (!((Matcher)entry.getKey()).match(received)) continue;
                        ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, (Integer)entry.getValue());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        };
    }

    private Transition createInputBooleanSignalTransition(final int source, final ReferencedArgument<boolean[]> queue, final LinkedHashMap<Matcher, Integer> signalToState) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((boolean[])queue.get(configuration)).length > 0;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                boolean[] currentQueue = (boolean[])queue.get(configuration);
                boolean received = FiacreQueueUtil.first(currentQueue);
                queue.set(configuration, FiacreQueueUtil.dequeue(ConcreteContextBehavior.this.id, currentQueue, actions2));
                for (Map.Entry entry : signalToState.entrySet()) {
                    try {
                        if (!((Matcher)entry.getKey()).match(received)) continue;
                        ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, (Integer)entry.getValue());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        };
    }

    private Transition createInputObjectSignalTransition(final int source, final ReferencedArgument<Object[]> queue, final LinkedHashMap<Matcher, Integer> signalToState) {
        return new Transition(this.id){

            @Override
            public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
                modifiedBehaviors[((ConcreteContextBehavior)ConcreteContextBehavior.this).rootId] = true;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                ConcreteContextConfiguration me = (ConcreteContextConfiguration)configuration.behaviorConfigurations[ConcreteContextBehavior.this.id];
                return me.getState() == source && ((Object[])queue.get(configuration)).length > 0;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                Object[] currentQueue = (Object[])queue.get(configuration);
                Object received = FiacreQueueUtil.first(currentQueue);
                queue.set(configuration, FiacreQueueUtil.dequeue(ConcreteContextBehavior.this.id, currentQueue, actions2));
                for (Map.Entry entry : signalToState.entrySet()) {
                    try {
                        if (!((Matcher)entry.getKey()).match(received)) continue;
                        ConcreteContextConfiguration.changeInTo(configuration.behaviorConfigurations, ConcreteContextBehavior.this.id, (Integer)entry.getValue());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        };
    }

    private Object getMessageValue(Message message, ExplorationContext context) {
        if (message instanceof Value) {
            return LiteralToJavaObject.toJava(((Value)message).getLiteral(), context.getProgram());
        }
        throw new IllegalArgumentException("'" + message.getClass().getSimpleName() + "' messages aren't supported with Explorer, use values.");
    }

    private Matcher getMessageMatcher(Message message, ExplorationContext context) {
        if (message instanceof Value) {
            return LiteralToMatcher.toMatcher(((Value)message).getLiteral(), context);
        }
        throw new IllegalArgumentException("'" + message.getClass().getSimpleName() + "' messages aren't supported with Explorer, use values.");
    }

    private short getOrCreateInformalId(String tag, SymbolsTable symbols) {
        try {
            return symbols.getInformalId(tag);
        }
        catch (IllegalArgumentException e) {
            return symbols.newInformalId(tag);
        }
    }
}

