/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.ccsl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ccsl.CCSLConfiguration;
import obp.explorer.runtime.ccsl.CCSLConfigurationGraph;
import obp.explorer.runtime.core.BroadcastChannel;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;
import org.xid.basics.serializer.Boost;

public class CCSLBehavior
extends ProcessBehavior {
    private static final String startStateName = "s0";
    CCSLConfigurationGraph clockConfigurationGraph;
    private Transition[][] transitions;
    private Set<BroadcastChannel> usedChannels = new HashSet<BroadcastChannel>();

    public CCSLBehavior(CCSLConfigurationGraph clockConfiguration, SymbolsTable symbols) {
        super("ccsl", symbols);
        this.clockConfigurationGraph = clockConfiguration;
    }

    @Override
    public int getStateId(String name) {
        short id = (short)this.clockConfigurationGraph.getStateId(name);
        if (id < 0) {
            throw new IllegalArgumentException("State '" + name + "' doesn't exist in process '" + this.name + "'.");
        }
        return id;
    }

    @Override
    public void link(ExplorationContext context, SymbolsTable symbols) {
        if (this.clockConfigurationGraph == null || this.clockConfigurationGraph.getTransitionCount() == 0) {
            this.transitions = new Transition[1][];
            this.transitions[0] = new Transition[0];
        } else {
            try {
                int stateCount = this.clockConfigurationGraph.getStateCount();
                this.transitions = new Transition[stateCount][];
                for (int state = 0; state < stateCount; ++state) {
                    ArrayList<Transition> explorerTransitionList = new ArrayList<Transition>();
                    Map<Integer, String> clocktransitions = this.clockConfigurationGraph.getFanout(state);
                    for (Map.Entry<Integer, String> transition : clocktransitions.entrySet()) {
                        explorerTransitionList.add(this.createTransition(state, transition, context, symbols));
                    }
                    this.transitions[state] = explorerTransitionList.isEmpty() ? new Transition[0] : explorerTransitionList.toArray(new Transition[explorerTransitionList.size()]);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.usedChannels = null;
    }

    private Transition createTransition(Integer source, Map.Entry<Integer, String> clockTransition, ExplorationContext context, SymbolsTable symbols) {
        try {
            if (clockTransition.getValue() == null) {
                return this.buildTransition(source, clockTransition.getKey());
            }
            short syncChannelId = symbols.getChannelId(clockTransition.getValue());
            return this.buildSyncTransition(source, clockTransition.getKey(), context.getChannel(syncChannelId), syncChannelId);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Channel named '" + clockTransition.getKey() + "' doesn't exist in root component.");
        }
    }

    private Transition buildTransition(final int source, final int target) {
        return new Transition(this.id){

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                CCSLConfiguration me = (CCSLConfiguration)configuration.behaviorConfigurations[CCSLBehavior.this.id];
                return me.state == (short)source;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                CCSLConfiguration me = (CCSLConfiguration)configuration.behaviorConfigurations[CCSLBehavior.this.id];
                me.state = (short)target;
                return true;
            }
        };
    }

    private Transition buildSyncTransition(final int source, final int target, final Channel syncChannel, final short channelId) {
        if (!this.usedChannels.contains(syncChannel)) {
            ((BroadcastChannel)syncChannel).addOutput();
            this.usedChannels.add((BroadcastChannel)syncChannel);
        }
        return new Transition(this.id){

            @Override
            public short getSynchronisationType() {
                return 2;
            }

            @Override
            public short getSynchronisationChannelId() {
                return channelId;
            }

            @Override
            public boolean guard(Configuration configuration, ExplorationContext context) {
                CCSLConfiguration me = (CCSLConfiguration)configuration.behaviorConfigurations[CCSLBehavior.this.id];
                return me.state == (short)source;
            }

            @Override
            public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
                CCSLConfiguration me = (CCSLConfiguration)configuration.behaviorConfigurations[CCSLBehavior.this.id];
                syncChannel.output(CCSLBehavior.this.id, actions2, new Object[0]);
                me.state = (short)target;
                return true;
            }
        };
    }

    @Override
    public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
        return new CCSLConfiguration((short)this.clockConfigurationGraph.getStateId(startStateName));
    }

    @Override
    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        CCSLConfiguration ccslConf = (CCSLConfiguration)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("'");
        text.append(this.name);
        text.append("' [");
        text.append("@" + this.clockConfigurationGraph.getStates().get(ccslConf.state));
        text.append("]");
        return text.toString();
    }

    @Override
    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return this.toStringConfiguration(behaviorConfiguration);
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        return new CCSLConfiguration(boost.readShort());
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
        CCSLConfiguration me = (CCSLConfiguration)processConfiguration;
        boost.writeShort(me.state);
    }

    @Override
    public Transition[] getTransitions(Configuration configuration) {
        CCSLConfiguration concreteContextConfiguration = (CCSLConfiguration)configuration.behaviorConfigurations[this.id];
        return this.transitions[concreteContextConfiguration.state];
    }
}

