/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import obp.explorer.runtime.Program;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public interface ProgramLoader
extends BoostObject {
    public Program loadProgram() throws IOException;

    public ClassLoader getClassLoader() throws IOException;

    public static class FromClass
    implements ProgramLoader {
        private final String programClassName;
        private final File programPath;
        private URLClassLoader classLoader;

        public FromClass(String programClassName, File programPath) {
            this.programClassName = programClassName;
            this.programPath = programPath;
        }

        protected FromClass(Boost boost) {
            this.programClassName = boost.readString();
            this.programPath = BoostUtil.readFile((Boost)boost);
        }

        @Override
        public Program loadProgram() throws IOException {
            Class<?> programClass;
            try {
                Class<?> localProgramClass;
                Class<?> loadedClass = this.getClassLoader().loadClass(this.programClassName);
                if (!Program.class.isAssignableFrom(loadedClass)) {
                    throw new IllegalArgumentException("Class '" + this.programClassName + "' isn't an Explorer program.");
                }
                programClass = localProgramClass = loadedClass;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Can't find program class '" + this.programClassName + " in '" + this.programPath.getPath() + "'.");
            }
            try {
                return (Program)programClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException("Can't load program '" + programClass.getCanonicalName() + "'.");
            }
        }

        @Override
        public URLClassLoader getClassLoader() throws IOException {
            if (this.classLoader == null) {
                try {
                    URL url = this.programPath.toURI().toURL();
                    this.classLoader = new URLClassLoader(new URL[]{url});
                }
                catch (MalformedURLException e) {
                    throw new IOException("Invalid program path '" + this.programPath.getPath() + "'.");
                }
            }
            return this.classLoader;
        }

        public void writeToBoost(Boost boost) {
            boost.writeString(this.programClassName);
            BoostUtil.writeFile((Boost)boost, (File)this.programPath);
        }
    }

    public static class FromMoCCML
    implements ProgramLoader {
        private ClassLoader classLoader;
        private File programPath;

        public FromMoCCML(File programPath) {
            this.programPath = programPath;
        }

        protected FromMoCCML(Boost boost) {
            this.programPath = BoostUtil.readFile((Boost)boost);
        }

        @Override
        public Program loadProgram() throws IOException {
            try {
                Class<?> readerClass = this.getClassLoader().loadClass("obp.languages.MoCCML.LTSReader");
                Object readerInstance = readerClass.newInstance();
                Method readMethod = readerClass.getMethod("read", File.class);
                Object lts = readMethod.invoke(readerInstance, this.programPath);
                Class<?> rootClass = this.getClassLoader().loadClass("obp.languages.MoCCML.runtime.MoCCMLRoot");
                Class<?> ltsClass = this.getClassLoader().loadClass("obp.languages.MoCCML.LTS");
                Constructor<?> rootConstructor = rootClass.getConstructor(ltsClass);
                return (Program)rootConstructor.newInstance(lts);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public ClassLoader getClassLoader() throws IOException {
            this.classLoader = ClassLoader.getSystemClassLoader();
            return this.classLoader;
        }

        public void writeToBoost(Boost boost) {
            BoostUtil.writeFile((Boost)boost, (File)this.programPath);
        }
    }

    public static class FromInstance
    extends Stub {
        private final Program program;

        public FromInstance(Program program) {
            this.program = program;
        }

        @Override
        public Program loadProgram() {
            return this.program;
        }
    }

    public static abstract class Stub
    implements ProgramLoader {
        @Override
        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }

        public void writeToBoost(Boost boost) {
            throw new IllegalArgumentException("FromInstance loader can't be serialized.");
        }
    }
}

