/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.expression_watcher;

import announce4j.Announcer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConfiguration;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.events.ExecutionEndedEvent;
import plug.events.OpenConfigurationEvent;
import plug.explorer.BFSExplorer;
import plug.folding.runtime.PreinitializedRuntime;
import plug.statespace.SimpleStateSpaceManager;
import plug.ui2.simulation.expression_watcher.WatchExpression;
import plug.ui2.simulation.expression_watcher.WatchExpressionConverter;
import plug.ui2.simulation.expression_watcher.WatchExpressionListCell;
import plug.utils.graph.IGraph;
import plug.utils.graph.algorithms.DijkstraShortestPath;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;
import properties.PropositionalLogic.interpreter.Evaluator;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class ExpressionsWatcher<C, T>
extends VBox {
    ObservableList<WatchExpression> theWatchExpList = FXCollections.observableArrayList((Object[])new WatchExpression[]{WatchExpression.NO_EXPRESSION});
    Evaluator watchEvaluator;
    AtomArrayValuationEvaluator apEvaluator;
    IAtomicPropositionsEvaluator atomicPropositionsEvaluator;
    List<String> atomList = new ArrayList<String>();
    ObjectProperty<C> inConfiguration;
    ObjectProperty<ITransitionRelation<C, T>> inTransitionRelationProperty;
    Consumer<List<C>> inCounterExampleHandler;
    ListView<WatchExpression> listView;
    PropositionalLogicModelFactory factory = PropositionalLogicModelFactory.eINSTANCE;

    public ExpressionsWatcher(ObjectProperty<C> inConfiguration, ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty, Consumer<List<C>> counterExampleHandler) {
        this.inConfiguration = inConfiguration;
        this.inTransitionRelationProperty = transitionRelationProperty;
        this.inCounterExampleHandler = counterExampleHandler;
        this.listView = new ListView(this.theWatchExpList);
        this.listView.setCellFactory(CheckBoxListCell.forListView(WatchExpression::selectedProperty));
        this.listView.setCellFactory(WatchExpressionListCell.forListView((Callback<WatchExpression, ObservableValue<Boolean>>)((Callback)WatchExpression::selectedProperty), new WatchExpressionConverter((List<WatchExpression>)this.theWatchExpList)));
        this.listView.setEditable(true);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listView.getSelectionModel().selectFirst();
        ContextMenu contextMenu = new ContextMenu();
        MenuItem goUntilTrueMenuItem = new MenuItem("Go until true");
        goUntilTrueMenuItem.setOnAction(this::goUntilTrue);
        MenuItem goUntilFalseMenuItem = new MenuItem("Go until false");
        goUntilFalseMenuItem.setOnAction(this::goUntilFalse);
        contextMenu.getItems().addAll((Object[])new MenuItem[]{goUntilTrueMenuItem, goUntilFalseMenuItem});
        this.setOnContextMenuRequested(cme -> {
            List weList = this.listView.getSelectionModel().getSelectedItems().stream().filter(e -> e != WatchExpression.NO_EXPRESSION).collect(Collectors.toList());
            if (weList.size() < 1) {
                return;
            }
            contextMenu.show(((Node)cme.getTarget()).getScene().getWindow(), cme.getScreenX(), cme.getScreenY());
        });
        this.listView.setOnEditStart(t -> this.listView.setPrefHeight((double)((this.theWatchExpList.size() - 1) * 25 + 60)));
        this.listView.setOnEditCommit(t -> {
            if (t.getNewValue() == WatchExpression.NO_EXPRESSION) {
                return;
            }
            if (this.listView.getSelectionModel().getSelectedIndices().contains((Object)(this.listView.getItems().size() - 1))) {
                this.listView.getItems().add((Object)WatchExpression.NO_EXPRESSION);
            }
            this.listView.getItems().set(t.getIndex(), t.getNewValue());
        });
        this.listView.setPrefHeight((double)(this.theWatchExpList.size() * 25));
        this.getChildren().add(this.listView);
        this.setFillWidth(true);
        this.theWatchExpList.addListener(this::listChangedCallback);
        this.setAtomicPropositionsEvaluator();
        transitionRelationProperty.addListener((v, o, n) -> this.setAtomicPropositionsEvaluator());
        inConfiguration.addListener(this::configurationChangedCallback);
    }

    void setAtomicPropositionsEvaluator() {
        if (this.inTransitionRelationProperty.get() == null) {
            return;
        }
        this.atomicPropositionsEvaluator = ((ITransitionRelation)this.inTransitionRelationProperty.get()).getAtomicPropositionEvaluator();
        if (this.atomicPropositionsEvaluator == null || this.atomList == null || this.atomList.isEmpty()) {
            return;
        }
        try {
            this.atomicPropositionsEvaluator.registerAtomicPropositions(this.atomList.toArray(new String[0]));
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            return;
        }
    }

    void goUntilTrue(ActionEvent ae) {
        this.goUntil(true);
    }

    void goUntilFalse(ActionEvent ae) {
        this.goUntil(false);
    }

    LogicalNegation negation(Expression exp) {
        LogicalNegation neg = this.factory.createLogicalNegation();
        neg.setOperand(exp);
        return neg;
    }

    void goUntil(boolean goTrue) {
        Expression breakpointCondition;
        List<Expression> weList = this.listView.getSelectionModel().getSelectedItems().stream().filter(e -> e != WatchExpression.NO_EXPRESSION).map(e -> (Expression)EcoreUtil.copy((EObject)e.expression)).collect(Collectors.toList());
        if (weList.size() < 1) {
            return;
        }
        Object object = breakpointCondition = goTrue ? (Expression)weList.get(0) : this.negation((Expression)weList.get(0));
        if (weList.size() > 1) {
            for (int idx = 1; idx < weList.size(); ++idx) {
                LogicalConjunction conjunction = this.factory.createLogicalConjunction();
                conjunction.setLhs(breakpointCondition);
                conjunction.setRhs((Expression)(goTrue ? weList.get(idx) : this.negation(weList.get(idx))));
                breakpointCondition = conjunction;
            }
        }
        HashMap<String, Integer> theAtomMap = new HashMap<String, Integer>();
        ArrayList<String> theAtomList = new ArrayList<String>();
        this.retrieveEcoreAtoms(weList, theAtomList, theAtomMap);
        Evaluator evaluator = new Evaluator();
        this.apEvaluator = new AtomArrayValuationEvaluator(theAtomMap);
        evaluator.setDefaultEvaluator((IAtomEvaluator)this.apEvaluator);
        if (this.atomicPropositionsEvaluator == null) {
            return;
        }
        try {
            this.atomicPropositionsEvaluator.registerAtomicPropositions(this.atomList.toArray(new String[0]));
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            return;
        }
        Expression conditionToCheck = breakpointCondition;
        SimpleBooleanProperty conditionWasChecked = new SimpleBooleanProperty(false);
        PreinitializedRuntime preinitializedRuntime = new PreinitializedRuntime((ITransitionRelation)this.inTransitionRelationProperty.get(), Collections.singleton(this.inConfiguration.get()));
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.parentTransitionStorage();
        BFSExplorer bfsExplorer = new BFSExplorer((ITransitionRelation)preinitializedRuntime, (IStateSpaceManager)stateSpaceManager);
        bfsExplorer.getAnnouncer().when(OpenConfigurationEvent.class, (arg_0, arg_1) -> this.lambda$goUntil$7(evaluator, conditionToCheck, (BooleanProperty)conditionWasChecked, (IStateSpaceManager)stateSpaceManager, arg_0, arg_1));
        bfsExplorer.getAnnouncer().when(ExecutionEndedEvent.class, (arg_0, arg_1) -> ExpressionsWatcher.lambda$goUntil$8((BooleanProperty)conditionWasChecked, arg_0, arg_1));
        bfsExplorer.execute();
    }

    void retrieveAllAtoms() {
        this.atomList.clear();
        HashMap<String, Integer> atomMap = new HashMap<String, Integer>();
        this.retrieveAtoms((List<WatchExpression>)this.listView.getItems(), this.atomList, atomMap);
        this.watchEvaluator = new Evaluator();
        this.apEvaluator = new AtomArrayValuationEvaluator(atomMap);
        this.watchEvaluator.setDefaultEvaluator((IAtomEvaluator)this.apEvaluator);
        if (this.atomicPropositionsEvaluator == null || this.atomList.isEmpty()) {
            return;
        }
        try {
            this.atomicPropositionsEvaluator.registerAtomicPropositions(this.atomList.toArray(new String[0]));
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            return;
        }
    }

    void updateValues(C inConfiguration) {
        this.apEvaluator.setValuation(this.atomicPropositionsEvaluator.getAtomicPropositionValuations((IConfiguration)inConfiguration));
        for (WatchExpression exp : this.theWatchExpList) {
            exp.updateValuation(this.watchEvaluator);
        }
    }

    void listChangedCallback(ListChangeListener.Change c) {
        this.retrieveAllAtoms();
        if (this.inConfiguration != null && this.inConfiguration.get() != null) {
            this.updateValues(this.inConfiguration.get());
        }
        this.listView.setPrefHeight((double)(this.theWatchExpList.size() * 25));
    }

    void configurationChangedCallback(ObservableValue<? extends C> observableValue, C old, C newC) {
        if (newC == null || this.apEvaluator == null || this.atomicPropositionsEvaluator == null) {
            return;
        }
        this.retrieveAllAtoms();
        this.updateValues(this.inConfiguration.get());
    }

    void retrieveAtoms(List<WatchExpression> inWatchList, List<String> outAtomList, Map<String, Integer> outAtomMap) {
        this.retrieveEcoreAtoms(inWatchList.stream().filter(e -> e != WatchExpression.NO_EXPRESSION).map(e -> e.expression).collect(Collectors.toList()), outAtomList, outAtomMap);
    }

    void retrieveEcoreAtoms(List<Expression> inExpressionList, List<String> outAtomList, Map<String, Integer> outAtomMap) {
        int idx = 0;
        for (Expression exp : inExpressionList) {
            String code;
            if (exp == null) continue;
            if (exp instanceof Atom && outAtomMap.put(code = ((Atom)exp).getCode(), idx++) == null) {
                outAtomList.add(code);
            }
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)exp, (boolean)true);
            while (iterator.hasNext()) {
                String code2;
                EObject current = (EObject)iterator.next();
                if (!(current instanceof Atom) || outAtomMap.put(code2 = ((Atom)current).getCode(), idx++) != null) continue;
                outAtomList.add(code2);
            }
        }
    }

    private static /* synthetic */ void lambda$goUntil$8(BooleanProperty conditionWasChecked, Announcer ann, ExecutionEndedEvent e) {
        if (!conditionWasChecked.get()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "The breakpoint cannot be reached from the current configuration", new ButtonType[0]);
            alert.setTitle("Note");
            alert.setHeaderText(null);
            alert.showAndWait();
        }
    }

    private /* synthetic */ void lambda$goUntil$7(Evaluator evaluator, Expression conditionToCheck, BooleanProperty conditionWasChecked, IStateSpaceManager stateSpaceManager, Announcer ann, OpenConfigurationEvent e) {
        this.apEvaluator.setValuation(this.atomicPropositionsEvaluator.getAtomicPropositionValuations((IConfiguration)e.getConfiguration()));
        boolean evaluationResult = evaluator.evaluate(conditionToCheck);
        if (evaluationResult) {
            e.getSource().getMonitor().hasToFinish();
            conditionWasChecked.set(true);
            List counterExample = new DijkstraShortestPath().getShortestPath((IGraph)stateSpaceManager.getGraphView(), (Collection)stateSpaceManager.initialConfigurations(), e.getConfiguration());
            this.inCounterExampleHandler.accept(counterExample);
        }
    }
}

