/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class CALFactory
extends BDDFactory {
    private static CALFactory INSTANCE;
    private static long zero;
    private static long one;
    public static final String REVISION = "$Revision: 1.6 $";

    public static BDDFactory init(int nodenum, int cachesize) {
        CALFactory f = new CALFactory();
        f.initialize(nodenum / 256, cachesize);
        return f;
    }

    private static native void registerNatives();

    private CALFactory() {
    }

    public BDD zero() {
        return new CALBDD(zero);
    }

    public BDD one() {
        return new CALBDD(one);
    }

    protected void initialize(int nodenum, int cachesize) {
        if (INSTANCE != null) {
            throw new InternalError("Error: CALFactory already initialized.");
        }
        INSTANCE = this;
        CALFactory.initialize0(nodenum, cachesize);
    }

    private static native void initialize0(int var0, int var1);

    public boolean isInitialized() {
        return CALFactory.isInitialized0();
    }

    private static native boolean isInitialized0();

    public void done() {
        INSTANCE = null;
        CALFactory.done0();
    }

    private static native void done0();

    public void setError(int code) {
    }

    public void clearError() {
    }

    public int setMaxNodeNum(int size) {
        System.err.println("Warning: setMaxNodeNum() not yet implemented");
        return 1000000;
    }

    public double setMinFreeNodes(double x) {
        System.err.println("Warning: setMinFreeNodes() not yet implemented");
        return 0.0;
    }

    public int setMaxIncrease(int x) {
        System.err.println("Warning: setMaxIncrease() not yet implemented");
        return 50000;
    }

    public double setCacheRatio(double x) {
        System.err.println("Warning: setCacheRatio() not yet implemented");
        return 0.0;
    }

    public int varNum() {
        return CALFactory.varNum0();
    }

    private static native int varNum0();

    public int setVarNum(int num) {
        return CALFactory.setVarNum0(num);
    }

    private static native int setVarNum0(int var0);

    public int duplicateVar(int var) {
        throw new UnsupportedOperationException();
    }

    public BDD ithVar(int var) {
        long id = CALFactory.ithVar0(var);
        return new CALBDD(id);
    }

    private static native long ithVar0(int var0);

    public BDD nithVar(int var) {
        BDD b = this.ithVar(var);
        BDD c = b.not();
        b.free();
        return c;
    }

    public void swapVar(int v1, int v2) {
        throw new UnsupportedOperationException();
    }

    public BDDPairing makePair() {
        return new CALBDDPairing();
    }

    public void printAll() {
        throw new UnsupportedOperationException();
    }

    public void printTable(BDD b) {
        throw new UnsupportedOperationException();
    }

    public int level2Var(int level) {
        return CALFactory.level2Var0(level);
    }

    private static native int level2Var0(int var0);

    public int var2Level(int var) {
        return CALFactory.var2Level0(var);
    }

    private static native int var2Level0(int var0);

    public void reorder(BDDFactory.ReorderMethod m) {
        throw new UnsupportedOperationException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        throw new UnsupportedOperationException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        throw new UnsupportedOperationException();
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        throw new UnsupportedOperationException();
    }

    public int getReorderTimes() {
        throw new UnsupportedOperationException();
    }

    public void disableReorder() {
        System.err.println("Warning: disableReorder() not yet implemented");
    }

    public void enableReorder() {
        System.err.println("Warning: enableReorder() not yet implemented");
    }

    public int reorderVerbose(int v) {
        throw new UnsupportedOperationException();
    }

    public void setVarOrder(int[] neworder) {
        CALFactory.setVarOrder0(neworder);
    }

    private static native void setVarOrder0(int[] var0);

    public void addVarBlock(BDD var, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    public void varBlockAll() {
        throw new UnsupportedOperationException();
    }

    public void clearVarBlocks() {
        throw new UnsupportedOperationException();
    }

    public void printOrder() {
        throw new UnsupportedOperationException();
    }

    public int nodeCount(Collection r) {
        throw new UnsupportedOperationException();
    }

    public int getNodeTableSize() {
        throw new UnsupportedOperationException();
    }

    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    public int getNodeNum() {
        throw new UnsupportedOperationException();
    }

    public int reorderGain() {
        throw new UnsupportedOperationException();
    }

    public void printStat() {
        throw new UnsupportedOperationException();
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new CALBDDDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new CALBDDBitVector(a);
    }

    public double setIncreaseFactor(double x) {
        System.err.println("Warning: setIncreaseFactor() not yet implemented");
        return 0.0;
    }

    public int setNodeTableSize(int n) {
        System.err.println("Warning: setNodeTableSize() not yet implemented");
        return 0;
    }

    public int setCacheSize(int n) {
        System.err.println("Warning: setCacheSize() not yet implemented");
        return 0;
    }

    public String getVersion() {
        return "CAL " + REVISION.substring(11, REVISION.length() - 2);
    }

    static {
        String libname = "cal";
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError x) {
            libname = System.mapLibraryName(libname);
            String currentdir = CALFactory.getProperty("user.dir", ".");
            String sep = CALFactory.getProperty("file.separator", "/");
            System.load(currentdir + sep + libname);
        }
        CALFactory.registerNatives();
    }

    private static class CALBDDBitVector
    extends BDDBitVector {
        private CALBDDBitVector(int a) {
            super(a);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CALBDDPairing
    extends BDDPairing {
        long _ptr = CALBDDPairing.alloc();

        private CALBDDPairing() {
        }

        private static native long alloc();

        public void set(int oldvar, int newvar) {
            CALBDDPairing.set0(this._ptr, oldvar, newvar);
        }

        private static native void set0(long var0, int var2, int var3);

        public void set(int oldvar, BDD newvar) {
            CALBDD c = (CALBDD)newvar;
            CALBDDPairing.set2(this._ptr, oldvar, c._ddnode_ptr);
        }

        private static native void set2(long var0, int var2, long var3);

        public void reset() {
            CALBDDPairing.reset0(this._ptr);
        }

        private static native void reset0(long var0);

        private static native void free0(long var0);
    }

    private static class CALBDDDomain
    extends BDDDomain {
        private CALBDDDomain(int index, BigInteger range) {
            super(index, range);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CALBDD
    extends BDD {
        private long _ddnode_ptr;
        static final long INVALID_BDD = -1L;
        static final boolean USE_FINALIZER = false;

        private CALBDD(long ddnode) {
            this._ddnode_ptr = ddnode;
            CALBDD.addRef(ddnode);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }

        public boolean isZero() {
            return this._ddnode_ptr == zero;
        }

        public boolean isOne() {
            return this._ddnode_ptr == one;
        }

        public int var() {
            return CALBDD.var0(this._ddnode_ptr);
        }

        private static native int var0(long var0);

        public BDD high() {
            long b = CALBDD.high0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long high0(long var0);

        public BDD low() {
            long b = CALBDD.low0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long low0(long var0);

        public BDD id() {
            return new CALBDD(this._ddnode_ptr);
        }

        public BDD not() {
            long b = CALBDD.not0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long not0(long var0);

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            CALBDD c = (CALBDD)thenBDD;
            CALBDD d = (CALBDD)elseBDD;
            long b = CALBDD.ite0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long ite0(long var0, long var2, long var4);

        public BDD relprod(BDD that, BDD var) {
            CALBDD c = (CALBDD)that;
            CALBDD d = (CALBDD)var;
            long b = CALBDD.relprod0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long relprod0(long var0, long var2, long var4);

        public BDD compose(BDD that, int var) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.compose0(this._ddnode_ptr, c._ddnode_ptr, var);
            return new CALBDD(b);
        }

        private static native long compose0(long var0, long var2, int var4);

        public BDD constrain(BDD that) {
            throw new UnsupportedOperationException();
        }

        public BDD exist(BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD forAll(BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD unique(BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD restrict(BDD var) {
            CALBDD c = (CALBDD)var;
            long b = CALBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long restrict0(long var0, long var2);

        public BDD restrictWith(BDD var) {
            CALBDD c = (CALBDD)var;
            long b = CALBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CALBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        public BDD simplify(BDD d) {
            throw new UnsupportedOperationException();
        }

        public BDD support() {
            long b = CALBDD.support0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long support0(long var0);

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            return new CALBDD(b);
        }

        private static native long apply0(long var0, long var2, int var4);

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CALBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD satOne() {
            long b = CALBDD.satOne0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long satOne0(long var0);

        public BDD fullSatOne() {
            throw new UnsupportedOperationException();
        }

        public BDD satOne(BDD var, boolean pol) {
            throw new UnsupportedOperationException();
        }

        public List allsat() {
            throw new UnsupportedOperationException();
        }

        public int nodeCount() {
            return CALBDD.nodeCount0(this._ddnode_ptr);
        }

        private static native int nodeCount0(long var0);

        public double pathCount() {
            return CALBDD.pathCount0(this._ddnode_ptr);
        }

        private static native double pathCount0(long var0);

        public double satCount() {
            return CALBDD.satCount0(this._ddnode_ptr);
        }

        private static native double satCount0(long var0);

        public int[] varProfile() {
            throw new UnsupportedOperationException();
        }

        private static native void addRef(long var0);

        private static native void delRef(long var0);

        public void free() {
            CALBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = -1L;
        }

        public BDD veccompose(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.veccompose0(this._ddnode_ptr, p._ptr);
            return new CALBDD(b);
        }

        private static native long veccompose0(long var0, long var2);

        public BDD replace(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.replace0(this._ddnode_ptr, p._ptr);
            return new CALBDD(b);
        }

        private static native long replace0(long var0, long var2);

        public BDD replaceWith(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.replace0(this._ddnode_ptr, p._ptr);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = b;
            return this;
        }

        public boolean equals(BDD that) {
            return this._ddnode_ptr == ((CALBDD)that)._ddnode_ptr;
        }

        public int hashCode() {
            return (int)this._ddnode_ptr;
        }
    }
}

