/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Variable;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.ExpressionUtil;

public class StatementUtil
extends ModelVisitor.Stub {
    public static <T extends Statement> T findFirst(Class<T> type, Statement statement) {
        if (type.isInstance(statement)) {
            return (T)((Statement)type.cast(statement));
        }
        if (statement instanceof CaseStmt) {
            for (Rule rule : ((CaseStmt)statement).getRuleList()) {
                T found = StatementUtil.findFirst(type, rule.getAction());
                if (found == null) continue;
                return found;
            }
            return null;
        }
        if (statement instanceof Foreach) {
            return StatementUtil.findFirst(type, ((Foreach)statement).getBody());
        }
        if (statement instanceof IfStmt) {
            T found = StatementUtil.findFirst(type, ((IfStmt)statement).getThen());
            if (found != null) {
                return found;
            }
            return StatementUtil.findFirst(type, ((IfStmt)statement).getElse());
        }
        if (statement instanceof Seq) {
            return StatementUtil.findFirst(type, ((Seq)statement).getStatementList());
        }
        if (statement instanceof Select) {
            return StatementUtil.findFirst(type, ((Select)statement).getStatementList());
        }
        if (statement instanceof WhileStmt) {
            return StatementUtil.findFirst(type, ((WhileStmt)statement).getBody());
        }
        return null;
    }

    public static <T extends Statement> T findFirst(Class<T> type, List<Statement> statements) {
        for (Statement one : statements) {
            T found = StatementUtil.findFirst(type, one);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static <T extends Statement> List<T> findAll(Class<T> type, Statement statement) {
        if (type.isInstance(statement)) {
            return Collections.singletonList(type.cast(statement));
        }
        if (statement instanceof CaseStmt) {
            ArrayList<T> found = new ArrayList<T>();
            for (Rule rule : ((CaseStmt)statement).getRuleList()) {
                found.addAll(StatementUtil.findAll(type, rule.getAction()));
            }
            return found;
        }
        if (statement instanceof Foreach) {
            return StatementUtil.findAll(type, ((Foreach)statement).getBody());
        }
        if (statement instanceof IfStmt) {
            ArrayList<T> found = new ArrayList<T>();
            found.addAll(StatementUtil.findAll(type, ((IfStmt)statement).getThen()));
            found.addAll(StatementUtil.findAll(type, ((IfStmt)statement).getElse()));
            return found;
        }
        if (statement instanceof Seq) {
            return StatementUtil.findAll(type, ((Seq)statement).getStatementList());
        }
        if (statement instanceof Select) {
            return StatementUtil.findAll(type, ((Select)statement).getStatementList());
        }
        if (statement instanceof WhileStmt) {
            return StatementUtil.findAll(type, ((WhileStmt)statement).getBody());
        }
        return Collections.emptyList();
    }

    public static <T extends Statement> List<T> findAll(Class<T> type, List<Statement> statements) {
        ArrayList<T> found = new ArrayList<T>();
        for (Statement one : statements) {
            found.addAll(StatementUtil.findAll(type, one));
        }
        return found;
    }

    public static Set<Variable> findUsedVariables(Statement statement) {
        ArrayList<Exp> expressionList = new ArrayList<Exp>();
        StatementUtil.collectAllExpressions(statement, expressionList);
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        StatementUtil.collectAllPatterns(statement, patternList);
        ExpressionUtil visitor = new ExpressionUtil();
        for (Exp exp : expressionList) {
            exp.accept(visitor);
        }
        for (Pattern pattern : patternList) {
            pattern.accept(visitor);
        }
        return visitor.getVariableSet();
    }

    public static Set<Variable> findModifiedVariables(Statement statement) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        StatementUtil.collectAllPatterns(statement, patternList);
        ExpressionUtil visitor = new ExpressionUtil(true);
        for (Pattern pattern : patternList) {
            pattern.accept(visitor);
        }
        return visitor.getVariableSet();
    }

    public static void collectAllExpressions(Statement statement, List<Exp> result) {
        if (statement instanceof DeterministicAssignment) {
            for (SingleAssignment single : ((DeterministicAssignment)statement).getAssignmentList()) {
                result.add(single.getRhs());
            }
        } else if (statement instanceof Emission) {
            for (Exp arg : ((Emission)statement).getArgList()) {
                result.add(arg);
            }
        } else if (statement instanceof CaseStmt) {
            CaseStmt caseStmt = (CaseStmt)statement;
            result.add(caseStmt.getExp());
            for (Rule rule : caseStmt.getRuleList()) {
                StatementUtil.collectAllExpressions(rule.getAction(), result);
            }
        } else if (statement instanceof Foreach) {
            StatementUtil.collectAllExpressions(((Foreach)statement).getBody(), result);
        } else if (statement instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)statement;
            result.add(ifStmt.getCondition());
            StatementUtil.collectAllExpressions(ifStmt.getThen(), result);
            StatementUtil.collectAllExpressions(ifStmt.getElse(), result);
        } else if (statement instanceof Seq) {
            for (Statement child : ((Seq)statement).getStatementList()) {
                StatementUtil.collectAllExpressions(child, result);
            }
        } else if (statement instanceof Select) {
            for (Statement child : ((Select)statement).getStatementList()) {
                StatementUtil.collectAllExpressions(child, result);
            }
        } else if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            result.add(whileStmt.getCondition());
            StatementUtil.collectAllExpressions(whileStmt.getBody(), result);
        }
    }

    public static void collectAllPatterns(Statement statement, List<Pattern> result) {
        if (statement instanceof DeterministicAssignment) {
            for (SingleAssignment single : ((DeterministicAssignment)statement).getAssignmentList()) {
                result.add(single.getLhs());
            }
        } else if (statement instanceof Reception) {
            List<Pattern> patternList = ((Reception)statement).getPatternList();
            for (Pattern pattern : patternList) {
                result.add(pattern);
            }
        } else if (statement instanceof CaseStmt) {
            for (Rule rule : ((CaseStmt)statement).getRuleList()) {
                result.add(rule.getLhs());
                StatementUtil.collectAllPatterns(rule.getAction(), result);
            }
        } else if (statement instanceof Foreach) {
            StatementUtil.collectAllPatterns(((Foreach)statement).getBody(), result);
        } else if (statement instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)statement;
            StatementUtil.collectAllPatterns(ifStmt.getThen(), result);
            StatementUtil.collectAllPatterns(ifStmt.getElse(), result);
        } else if (statement instanceof Seq) {
            for (Statement child : ((Seq)statement).getStatementList()) {
                StatementUtil.collectAllPatterns(child, result);
            }
        } else if (statement instanceof Select) {
            for (Statement child : ((Select)statement).getStatementList()) {
                StatementUtil.collectAllPatterns(child, result);
            }
        } else if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            StatementUtil.collectAllPatterns(whileStmt.getBody(), result);
        }
    }

    public static List<Pattern> filterPatternsForVariable(Variable variable, List<Pattern> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (Pattern pattern : patterns) {
            if (!ExpressionUtil.findUsedVariables(pattern).contains(variable)) continue;
            result.add(pattern);
        }
        return result;
    }
}

