/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.error;

import org.xid.basics.error.Diagnostic;

public interface ErrorHandler {
    public static final ErrorHandler simple = new ErrorHandler(){

        @Override
        public void handleError(int type, String message) {
            this.handleError(new Diagnostic.Stub(type, message));
        }

        @Override
        public void handleError(Diagnostic diagnostic) {
            switch (diagnostic.getLevel()) {
                case 0: {
                    System.out.println(diagnostic.getMessage());
                    break;
                }
                case 1: {
                    System.err.println(diagnostic.getMessage());
                    break;
                }
                case 2: {
                    System.err.println(diagnostic.getMessage());
                    throw new RuntimeException(diagnostic.getMessage());
                }
            }
        }
    };

    public void handleError(int var1, String var2);

    public void handleError(Diagnostic var1);
}

