/*
 * Decompiled with CFR 0.152.
 */
package spinja.util.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import spinja.util.compiler.ParseException;
import spinja.util.compiler.Parser;
import spinja.util.compiler.Token;
import spinja.util.compiler.Tokenizer;
import spinja.util.compiler.Type;

public class Compiler<TYPE extends Type, TOKEN extends Token<TYPE>> {
    private final Tokenizer<TYPE, TOKEN> tokenizer;
    private TOKEN buffer;

    public Compiler(Tokenizer<TYPE, TOKEN> tokenizer) {
        this.tokenizer = tokenizer;
    }

    protected final TOKEN next() throws ParseException {
        if (this.buffer == null) {
            this.buffer = this.tokenizer.nextToken();
        }
        return this.buffer;
    }

    protected final boolean nextIs(TYPE ... TYPEArray) throws ParseException {
        for (TYPE TYPE : TYPEArray) {
            if (((Token)this.next()).getType() != TYPE) continue;
            return true;
        }
        return false;
    }

    protected final TOKEN take() throws ParseException {
        TOKEN TOKEN = this.next();
        this.buffer = null;
        return TOKEN;
    }

    protected final TOKEN expect(TYPE TYPE) throws ParseException {
        TOKEN TOKEN = this.take();
        if (((Token)TOKEN).getType() != TYPE) {
            throw new ParseException("Expected a " + TYPE + ", got a " + ((Token)TOKEN).getType(), (Token<?>)TOKEN);
        }
        return TOKEN;
    }

    protected final TOKEN expect(TYPE ... TYPEArray) throws ParseException {
        TOKEN TOKEN = this.take();
        for (TYPE TYPE : TYPEArray) {
            if (((Token)TOKEN).getType() != TYPE) continue;
            return TOKEN;
        }
        throw new ParseException("Expected one of " + Arrays.toString(TYPEArray) + ", got a " + ((Token)TOKEN).getType(), (Token<?>)TOKEN);
    }

    protected final <RESULT> List<RESULT> oneOrMore(Parser<RESULT> parser) throws ParseException {
        ArrayList<RESULT> arrayList = new ArrayList<RESULT>(2);
        arrayList.add(parser.parse());
        while (parser.canParse()) {
            arrayList.add(parser.parse());
        }
        return arrayList;
    }

    protected final <RESULT> List<RESULT> zeroOrMore(Parser<RESULT> parser) throws ParseException {
        ArrayList<RESULT> arrayList = new ArrayList<RESULT>(1);
        while (parser.canParse()) {
            arrayList.add(parser.parse());
        }
        return arrayList;
    }

    protected final <RESULT> RESULT zeroOrOne(Parser<RESULT> parser) throws ParseException {
        if (parser.canParse()) {
            return parser.parse();
        }
        return null;
    }

    protected final <RESULT> List<RESULT> separatedList(TYPE TYPE, Parser<RESULT> parser) throws ParseException {
        ArrayList<RESULT> arrayList = new ArrayList<RESULT>(2);
        arrayList.add(parser.parse());
        while (((Token)this.next()).getType() == TYPE) {
            this.take();
            arrayList.add(parser.parse());
        }
        return arrayList;
    }
}

