/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.util.Arrays;
import spinja.exceptions.SpinJaException;
import spinja.model.Transition;
import spinja.search.SearchableStack;

public class Stack
implements SearchableStack {
    private int top = -1;
    private final int size;
    private final Transition[] lastTransition;
    private final byte[][] encoded;
    private final int[] identifiers;
    private final int[] hashTable;
    private final int hashMask;
    private long bytes;

    public Stack(int n) {
        this.size = n;
        this.lastTransition = new Transition[n];
        this.encoded = new byte[n][];
        this.identifiers = new int[n];
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        n2 = 1 << n2;
        this.hashTable = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.hashTable[i] = Integer.MIN_VALUE;
        }
        this.hashMask = n2 - 1;
        this.bytes = 128 + 12 * n + 4 * n2;
    }

    public void clearStack() {
        while (this.top >= 0) {
            this.pop();
        }
    }

    public boolean containsState(byte[] byArray) {
        for (int i = this.top; i >= 0; --i) {
            if (!Arrays.equals(this.encoded[i], byArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsState(byte[] byArray, int n) {
        int n2 = n & this.hashMask;
        int n3 = n | 1;
        int n4 = 0;
        while ((n4 = this.hashTable[n2]) >= 0) {
            if (Arrays.equals(this.encoded[n4], byArray)) {
                return true;
            }
            n2 = n2 + n3 & this.hashMask;
        }
        return false;
    }

    public long getBytes() {
        return this.bytes;
    }

    public Transition getLastTransition() {
        return this.lastTransition[this.top];
    }

    public int getSize() {
        return this.top + 1;
    }

    public byte[] getTop() {
        return this.encoded[this.top];
    }

    public Transition getTransition(int n) {
        return this.lastTransition[n];
    }

    public byte[] getState(int n) {
        return this.encoded[n];
    }

    public byte[] pop() {
        if (this.top == -1) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes -= (long)(19 + this.encoded[this.top].length >> 3 << 3);
        byte[] byArray = this.encoded[this.top];
        this.encoded[this.top] = null;
        this.lastTransition[this.top] = null;
        int n = this.identifiers[this.top] & this.hashMask;
        int n2 = this.identifiers[this.top] | 1;
        while (this.hashTable[n] != this.top) {
            n = n + n2 & this.hashMask;
        }
        this.hashTable[n] = Integer.MIN_VALUE;
        --this.top;
        return byArray;
    }

    public boolean push(byte[] byArray, int n) {
        if (this.top == this.size - 1) {
            return false;
        }
        ++this.top;
        this.encoded[this.top] = byArray;
        this.identifiers[this.top] = n;
        this.bytes += (long)(19 + byArray.length >> 3 << 3);
        int n2 = n & this.hashMask;
        int n3 = n | 1;
        while (this.hashTable[n2] >= 0) {
            n2 = n2 + n3 & this.hashMask;
        }
        this.hashTable[n2] = this.top;
        return true;
    }

    public void takeTransition(Transition transition) throws SpinJaException {
        this.lastTransition[this.top] = transition;
        transition.take();
    }
}

