/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.util.Enumeration;
import tlc2.util.Vect;
import tlc2.value.Enumerable;
import tlc2.value.FcnRcdValue;
import tlc2.value.ModelValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import util.Assert;
import util.Set;

public final class MVPerm {
    private final ModelValue[] elems = new ModelValue[ModelValue.mvs.length];
    private int count = 0;

    private MVPerm() {
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MVPerm) {
            MVPerm perm = (MVPerm)obj;
            for (int i = 0; i < this.elems.length; ++i) {
                if (!(this.elems[i] == null ? perm.elems[i] != null : !this.elems[i].equals(perm.elems[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int res = 0;
        for (int i = 0; i < this.elems.length; ++i) {
            ModelValue mv = this.elems[i];
            if (mv == null) continue;
            res = 31 * res + mv.val.hashCode();
        }
        return res;
    }

    private final int size() {
        return this.count;
    }

    final ModelValue get(ModelValue k) {
        return this.elems[k.index];
    }

    private final void put(ModelValue k, ModelValue elem) {
        if (!k.equals(elem) && this.elems[k.index] == null) {
            this.elems[k.index] = elem;
            ++this.count;
        }
    }

    private final void put(int i, ModelValue elem) {
        if (this.elems[i] == null && elem != null) {
            this.elems[i] = elem;
            ++this.count;
        }
    }

    public final MVPerm compose(MVPerm perm) {
        MVPerm res = new MVPerm();
        for (int i = 0; i < this.elems.length; ++i) {
            ModelValue mv = this.elems[i];
            if (mv == null) {
                res.put(i, perm.elems[i]);
                continue;
            }
            ModelValue mv1 = perm.elems[mv.index];
            if (mv1 == null) {
                res.put(i, mv);
                continue;
            }
            if (ModelValue.mvs[i].equals(mv1)) continue;
            res.put(i, mv1);
        }
        return res;
    }

    public static final MVPerm[] permutationSubgroup(Enumerable enumerable) {
        Value elem;
        ValueEnumeration Enum2 = enumerable.elements();
        int sz = enumerable.size() - 1;
        Set perms = new Set(sz);
        Vect permVec = new Vect(sz);
        while ((elem = Enum2.nextElement()) != null) {
            FcnRcdValue fcn = FcnRcdValue.convert(elem);
            if (fcn == null) {
                Assert.fail("The symmetry operator must specify a set of functions.");
            }
            MVPerm perm = new MVPerm();
            for (int i = 0; i < fcn.domain.length; ++i) {
                Value dval = fcn.domain[i];
                Value rval = fcn.values[i];
                if (dval instanceof ModelValue && rval instanceof ModelValue) {
                    perm.put((ModelValue)dval, (ModelValue)rval);
                    continue;
                }
                Assert.fail("Symmetry function must have model values as domain and range.");
            }
            if (perm.size() <= 0 || perms.put(perm) != null) continue;
            permVec.addElement(perm);
        }
        int gsz = permVec.size();
        int sz0 = 0;
        while (true) {
            int sz1 = permVec.size();
            for (int i = 0; i < gsz; ++i) {
                MVPerm perm1 = (MVPerm)permVec.elementAt(i);
                for (int j = sz0; j < sz1; ++j) {
                    MVPerm perm = perm1.compose((MVPerm)permVec.elementAt(j));
                    if (perm.size() <= 0 || perms.put(perm) != null) continue;
                    permVec.addElement(perm);
                }
            }
            if (sz1 == permVec.size()) break;
            sz0 = sz1;
        }
        MVPerm[] res = new MVPerm[permVec.size()];
        Enumeration permEnum = permVec.elements();
        for (int i = 0; i < res.length; ++i) {
            res[i] = (MVPerm)permEnum.nextElement();
        }
        return res;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        for (i = 0; i < this.elems.length; ++i) {
            if (this.elems[i] == null) continue;
            sb.append(ModelValue.mvs[i].toString());
            sb.append(" -> ");
            sb.append(this.elems[i].toString());
            break;
        }
        for (int j = i + 1; j < this.elems.length; ++j) {
            if (this.elems[j] == null) continue;
            sb.append(", ");
            sb.append(ModelValue.mvs[j].toString());
            sb.append(" -> ");
            sb.append(this.elems[j].toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

