/*
 * Decompiled with CFR 0.152.
 */
package plug.language.fiacre.diagnosis;

import java.util.ArrayList;
import java.util.List;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.predicate.Predicate;
import obp.util.PredicateUtil;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConfiguration;
import plug.language.fiacre.runtime.FiacreExplorationContext;

public class FiacreAtomicPropositionsEvaluator
implements IAtomicPropositionsEvaluator {
    protected final List<String> atomicPropositions = new ArrayList<String>();
    protected final List<Tester> testers = new ArrayList<Tester>();
    protected final FiacreExplorationContext context;

    public FiacreAtomicPropositionsEvaluator(FiacreExplorationContext context) {
        this.context = context;
    }

    public int[] registerAtomicPropositions(String[] atomicPropositions) throws Exception {
        int[] indexes = new int[atomicPropositions.length];
        for (int i = 0; i < atomicPropositions.length; ++i) {
            String proposition = atomicPropositions[i];
            int index = this.atomicPropositions.indexOf(proposition);
            if (index < 0) {
                indexes[i] = this.atomicPropositions.size();
                try {
                    Predicate predicate = PredicateUtil.readPredicate((String)atomicPropositions[i]);
                    Tester tester = new Tester(PredicateToEvaluator.toEvaluator((Predicate)predicate, (ExplorationContext)this.context, (SymbolsTable)this.context.symbols));
                    this.atomicPropositions.add(proposition);
                    this.testers.add(tester);
                    continue;
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("'" + atomicPropositions[i] + "' doesn't exist.");
                }
            }
            indexes[i] = index;
        }
        return indexes;
    }

    public boolean[] getAtomicPropositionValuations(IConfiguration configuration) {
        boolean[] valuations = new boolean[this.testers.size()];
        for (int i = 0; i < this.testers.size(); ++i) {
            Tester tester = this.testers.get(i);
            valuations[i] = tester != null && tester.test((Object)configuration);
        }
        return valuations;
    }

    public boolean getAtomicPropositionValuation(IConfiguration configuration, int atomPropositionId) {
        if (atomPropositionId < 0 || atomPropositionId >= this.testers.size()) {
            return false;
        }
        Tester tester = this.testers.get(atomPropositionId);
        return tester != null && tester.test((Object)configuration);
    }
}

