/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.cc2ifx.ConcreteContextToIF;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.partition.PathPartioner;
import obp.partition.SimplePartitioner;
import obp.transfo.cc.ConcreteContextExport;
import obp.transfo.cdl.CDLToConcreteContext;
import obp.ui.cdl.CDLViewer;
import obp.ui.cdl.OpenedUnit;
import obp.util.CDLUtil;
import obp.util.ConcreteContextUtil;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.NumberValidator;
import org.xid.basics.error.Validator;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class ExportAction
extends Action.Stub {
    private final CDLViewer app;

    public ExportAction(CDLViewer app) {
        super("Export\u2026", app.getResources().getImage("eclipse/export_wiz.gif"));
        this.app = app;
    }

    public int getVisibility() {
        List<CDLDeclaration> cdls = this.getCDLs(this.app.getSelection());
        return cdls != null && cdls.size() > 0 ? 1 : 2;
    }

    public OpenedUnit getOpenedUnit(Object selection) {
        if (selection instanceof OpenedUnit) {
            return (OpenedUnit)selection;
        }
        if (selection instanceof CDLDeclaration) {
            return this.app.getOpenedUnit((CDLDeclaration)selection);
        }
        return null;
    }

    public List<CDLDeclaration> getCDLs(Object selection) {
        if (selection instanceof OpenedUnit) {
            CDLUnit unit = ((OpenedUnit)selection).getUnit();
            if (unit != null) {
                return CDLUtil.findAllDeclarations(unit, CDLDeclaration.class);
            }
            return null;
        }
        if (selection instanceof CDLDeclaration) {
            return Collections.singletonList((CDLDeclaration)selection);
        }
        return null;
    }

    public int run(ActionMonitor monitor) {
        Object selection = this.app.getSelection();
        OpenedUnit openedCDL = this.getOpenedUnit(selection);
        List<CDLDeclaration> cdls = this.getCDLs(selection);
        final CheckboxField partitionField = new CheckboxField("Partition");
        final TextField parameterField = new TextField("Split parameter");
        parameterField.setValidator((Validator)new NumberValidator(2, "Invalid split parameter", Basics.POSITIVE | Basics.NOT_ZERO));
        parameterField.setIntValue(1);
        parameterField.setEnable(partitionField.getValue());
        partitionField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                parameterField.setEnable(partitionField.getValue());
            }
        });
        final TextField directoryField = new TextField("Output directory");
        directoryField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid output directory."){

            public boolean isValid(String value) {
                if (value == null) {
                    return false;
                }
                File file = new File(value);
                return file.exists() && file.isDirectory() && file.canWrite();
            }
        });
        directoryField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(ExportAction.this.app.getShell());
                dialog.setFilterPath(directoryField.getValue());
                String newDirectory = dialog.open();
                if (newDirectory == null) {
                    return 2;
                }
                directoryField.setValue(newDirectory);
                return 1;
            }
        });
        if (openedCDL.getFile() != null) {
            directoryField.setValue(openedCDL.getFile().getParent());
        }
        LinkedHashMap<String, String> extentions = new LinkedHashMap<String, String>();
        extentions.put("Simple", "scc");
        extentions.put("IF", "ifp");
        extentions.put("Dot", "dot");
        extentions.put("Scenario", "scn");
        extentions.put("Binary", "bcc");
        ChoiceField exportTypeField = new ChoiceField("Type", (Object)"Simple", new ArrayList(extentions.keySet()), 0);
        CompositeField cdlField = new CompositeField("CDL", 16, new Field[]{partitionField, parameterField});
        CompositeField outputField = new CompositeField("Output", 16, new Field[]{directoryField, exportTypeField});
        CompositeField mainField = new CompositeField(new Field[]{cdlField, outputField});
        StringBuilder title = new StringBuilder();
        title.append("Export CDL ");
        for (CDLDeclaration cdl : cdls) {
            title.append("'");
            title.append(cdl.getName());
            title.append("' ");
        }
        FieldDialog dialog = new FieldDialog("CDLViewer", title.toString(), 0, (Field)mainField);
        if (dialog.open() != 0) {
            return 2;
        }
        try {
            File outputDirectory = new File(directoryField.getValue());
            ArrayList<ConcreteContext> toExport = new ArrayList<ConcreteContext>();
            for (CDLDeclaration cdl : cdls) {
                ConcreteContext completeCc = CDLToConcreteContext.toConcreteContext(openedCDL.getUnit(), cdl);
                if (partitionField.getValue()) {
                    SimplePartitioner partitioner = new SimplePartitioner(completeCc, parameterField.getIntValue());
                    while (partitioner.hasNext()) {
                        toExport.add(partitioner.next());
                    }
                } else {
                    toExport.add(completeCc);
                }
                String type = (String)exportTypeField.getValue();
                for (ConcreteContext context : toExport) {
                    String name = cdl.getName() + "." + (String)extentions.get(type);
                    File destination = new File(outputDirectory, name);
                    if ("Simple".equals(type)) {
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toSimple(context), (String)"UTF-8");
                        continue;
                    }
                    if ("IF".equals(type)) {
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextToIF.toProcess(context), (String)"UTF-8");
                        continue;
                    }
                    if ("Dot".equals(type)) {
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toDot(context), (String)"UTF-8");
                        continue;
                    }
                    if ("Scenario".equals(type)) {
                        PathPartioner partioner = new PathPartioner(context);
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toSimple(partioner.next()), (String)"UTF-8");
                        continue;
                    }
                    if (!"Binary".equals(type)) continue;
                    ConcreteContextUtil.saveCC(context, destination);
                }
            }
        }
        catch (Exception e) {
            this.app.handleError(2, DiagnosticUtil.createMessage((Throwable)e));
            return 3;
        }
        return 1;
    }
}

