/*
 * Decompiled with CFR 0.152.
 */
package obp.languages.MoCCML;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import obp.languages.MoCCML.LTS;
import obp.languages.MoCCML.LTSTransition;

public class LTSReader {
    BufferedReader reader;
    int nbClocks = 0;
    int nbConfigurations = 0;
    int nbTransitions = 0;
    int configurationSize = 0;
    int[][] configurationsData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LTS read(File ltsFile) {
        LTS lts = null;
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(ltsFile)));
            this.readSizes();
            String[] clocks = this.readClocks();
            String[] stateNames = this.readStateNames();
            int initialStateID = Integer.parseInt(this.reader.readLine());
            this.configurationsData = this.readConfigurations();
            LTSTransition[] transitions = this.readTransitions();
            lts = new LTS(clocks, stateNames, initialStateID, transitions, this.configurationsData[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return lts;
    }

    void readSizes() throws IOException {
        StringTokenizer sT = new StringTokenizer(this.reader.readLine());
        assert (sT.countTokens() == 4);
        this.nbClocks = Integer.parseInt(sT.nextToken());
        this.nbConfigurations = Integer.parseInt(sT.nextToken());
        this.nbTransitions = Integer.parseInt(sT.nextToken());
        this.configurationSize = Integer.parseInt(sT.nextToken());
    }

    String[] readClocks() throws IOException {
        String[] clocks = new String[this.nbClocks];
        StringTokenizer sT = new StringTokenizer(this.reader.readLine());
        assert (sT.countTokens() == this.nbClocks);
        for (int i = 0; i < this.nbClocks; ++i) {
            clocks[i] = sT.nextToken().intern();
        }
        return clocks;
    }

    String[] readStateNames() throws IOException {
        String[] states = new String[this.nbConfigurations];
        String statesLine = this.reader.readLine();
        StringTokenizer sT = new StringTokenizer(statesLine);
        assert (sT.countTokens() == this.nbConfigurations);
        for (int i = 0; i < this.nbConfigurations; ++i) {
            states[i] = sT.nextToken().intern();
        }
        return states;
    }

    LTSTransition[] readTransitions() throws IOException {
        LTSTransition[] transitions = new LTSTransition[this.nbTransitions];
        for (int i = 0; i < this.nbTransitions; ++i) {
            String transLine = this.reader.readLine();
            StringTokenizer sT = new StringTokenizer(transLine);
            assert (sT.countTokens() >= 2);
            LTSTransition transition = new LTSTransition(0);
            transition.sourceID = Integer.parseInt(sT.nextToken());
            int nbTickingClocks = sT.countTokens() - 1;
            transition.tickingClocks = new int[nbTickingClocks];
            for (int idx = 0; idx < nbTickingClocks; ++idx) {
                transition.tickingClocks[idx] = Integer.parseInt(sT.nextToken());
            }
            transition.targetID = Integer.parseInt(sT.nextToken());
            transition.targetData = this.configurationsData[transition.targetID];
            transitions[i] = transition;
        }
        return transitions;
    }

    int[][] readConfigurations() throws IOException {
        int[][] stateValues = new int[this.nbConfigurations][this.configurationSize];
        for (int i = 0; i < this.nbConfigurations; ++i) {
            String confLine = this.reader.readLine();
            StringTokenizer sT = new StringTokenizer(confLine);
            assert (sT.countTokens() == this.configurationSize);
            for (int j = 0; j < this.configurationSize; ++j) {
                stateValues[i][j] = Integer.parseInt(sT.nextToken());
            }
        }
        return stateValues;
    }
}

