/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.external;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.behaviour.Statement;
import obp.if2.data.types.PredefinedType;
import obp.if2.data.variables.FormalParameter;
import obp.if2.structure.Entity;

public class Procedure
implements NamedElement {
    private final List<FormalParameter> formalParametersList = new ArrayList<FormalParameter>();
    private PredefinedType returnType;
    private String bodyCode;
    private Statement bodyStatement;
    private Entity entity;
    private String name;

    public List<FormalParameter> getFormalParametersList() {
        return Collections.unmodifiableList(this.formalParametersList);
    }

    public int getFormalParametersCount() {
        return this.formalParametersList.size();
    }

    public FormalParameter getFormalParameters(int index) {
        if (index < 0 || index >= this.getFormalParametersCount()) {
            return null;
        }
        return this.formalParametersList.get(index);
    }

    public void addFormalParameters(FormalParameter newValue) {
        this.addFormalParameters(this.getFormalParametersCount(), newValue);
    }

    public void addFormalParameters(int index, FormalParameter newValue) {
        this.formalParametersList.add(index, newValue);
    }

    public FormalParameter setFormalParameters(int index, FormalParameter newValue) {
        return this.formalParametersList.set(index, newValue);
    }

    public void addAllFormalParameters(Collection<FormalParameter> toAddList) {
        for (FormalParameter newValue : toAddList) {
            this.addFormalParameters(this.getFormalParametersCount(), newValue);
        }
    }

    public void removeFormalParameters(FormalParameter value) {
        int index = this.formalParametersList.indexOf(value);
        if (index >= 0) {
            this.removeFormalParameters(index);
        }
    }

    public void removeFormalParameters(int index) {
        this.formalParametersList.remove(index);
    }

    public PredefinedType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(PredefinedType newValue) {
        if (this.returnType == null ? newValue != null : !this.returnType.equals(newValue)) {
            this.returnType = newValue;
        }
    }

    public String getBodyCode() {
        return this.bodyCode;
    }

    public void setBodyCode(String newValue) {
        if (this.bodyCode == null ? newValue != null : !this.bodyCode.equals(newValue)) {
            this.bodyCode = newValue;
        }
    }

    public Statement getBodyStatement() {
        return this.bodyStatement;
    }

    public void setBodyStatement(Statement newValue) {
        if (this.bodyStatement == null ? newValue != null : !this.bodyStatement.equals(newValue)) {
            this.bodyStatement = newValue;
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity newValue) {
        if (this.entity == null ? newValue != null : !this.entity.equals(newValue)) {
            this.entity = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitProcedure(this);
    }
}

