/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import java.util.Arrays;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.util.ActionUtil;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class SynchronousCommunicationAction
implements AtomicAction {
    public final short sourceId;
    public final short targetId;
    public final short channelId;
    public final Object[] values;

    public SynchronousCommunicationAction(short sourceId, short targetId, short channelId, Object[] values) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.channelId = channelId;
        this.values = values;
    }

    protected SynchronousCommunicationAction(Boost boost) {
        boost.register((BoostObject)this);
        this.sourceId = boost.readShort();
        this.targetId = boost.readShort();
        this.channelId = boost.readShort();
        this.values = ActionUtil.readValueArray(boost);
    }

    public void writeToBoost(Boost boost) {
        boost.writeShort(this.sourceId);
        boost.writeShort(this.targetId);
        boost.writeShort(this.channelId);
        ActionUtil.writeValueArray(boost, this.values);
    }

    public int hashCode() {
        int total = 17;
        total = total * 37 + this.sourceId;
        total = total * 37 + this.targetId;
        total = total * 37 + this.channelId;
        total = total * 37 + (this.values == null ? 0 : this.values.hashCode());
        return total;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SynchronousCommunicationAction) {
            SynchronousCommunicationAction other = (SynchronousCommunicationAction)obj;
            return this.sourceId == other.sourceId && this.targetId == other.targetId && this.channelId == other.channelId && this.values == null ? other.values == null : this.values.equals(other.values);
        }
        return false;
    }

    @Override
    public String toFancyString(SymbolsTable symbols) {
        StringBuilder label = new StringBuilder();
        label.append("sync: {");
        label.append(symbols.getChannelName(this.channelId));
        label.append("(");
        if (this.values != null) {
            label.append(Arrays.toString(this.values));
        }
        label.append(")");
        if (this.sourceId >= 0) {
            label.append(" from ");
            label.append(symbols.getBehaviorName(this.sourceId));
            label.append(" to ");
        } else {
            label.append(" with ");
        }
        if (this.targetId >= 0) {
            label.append(symbols.getBehaviorName(this.targetId));
        }
        label.append("}");
        return label.toString();
    }

    public String toString() {
        StringBuilder label = new StringBuilder();
        label.append(this.channelId);
        label.append("(");
        if (this.values != null) {
            label.append(Arrays.toString(this.values));
        }
        label.append(")");
        if (this.sourceId >= 0) {
            label.append(" from ");
            label.append(this.sourceId);
            label.append(" to ");
        } else {
            label.append(" with ");
        }
        if (this.targetId >= 0) {
            label.append(this.targetId);
        }
        return label.toString();
    }
}

