/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collection;
import javafx.application.Application;
import javafx.scene.Node;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;
import plug.ui2.AbstractUIBase;
import plug.ui2.VerificationMainView;

public class PlugUI
extends AbstractUIBase {
    @Argument(metaVar="<model-path>", usage="The path to the model file")
    Path modelPath;
    @Option(name="-p", aliases={"--property-file"}, usage="The path to the .gpsl property file")
    Path propertiesPath;
    @Option(name="-h", aliases={"--help"}, usage="Print this help message and exists", help=true)
    boolean help;

    public void printHelp(PrintStream printStream, CmdLineParser parser) {
        String className = this.getClass().getCanonicalName();
        printStream.println("java " + className + " [options...] arguments...");
        parser.printUsage((OutputStream)printStream);
        printStream.println();
        printStream.println("  Example: java " + className + " " + parser.printExample(OptionHandlerFilter.REQUIRED) + " [<model-path>]");
        System.exit(1);
    }

    @Override
    public Node getMainComponent() {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument((Collection)this.getParameters().getRaw());
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.printHelp(System.err, parser);
            System.exit(1);
        }
        if (this.help) {
            this.printHelp(System.out, parser);
            System.exit(0);
        }
        return new VerificationMainView(this.modelPath, this.propertiesPath, this);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

