/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VariableUsageAnalysis
extends AEFDModelVisitor.Stub {
    private Map<AEFDBooleanVariable, Usage> usageMap = new HashMap<AEFDBooleanVariable, Usage>();
    private Map<VarDiagnostic, List<AEFDBooleanVariable>> diagnosticMap = new HashMap<VarDiagnostic, List<AEFDBooleanVariable>>();
    private AEFDModel model;

    public List<AEFDBooleanVariable> getVariables(VarDiagnostic diagnostic) {
        return this.diagnosticMap.get((Object)diagnostic);
    }

    public VarDiagnostic getDiagnostic(AEFDBooleanVariable variable) {
        return this.usageMap.get(variable).getDiagnostic();
    }

    private Usage getUsage(AEFDBooleanVariable variable) {
        Usage result = this.usageMap.get(variable);
        if (result == null) {
            result = new Usage();
            this.usageMap.put(variable, result);
        }
        return result;
    }

    private void reportVarWrite(AEFDBooleanVariable variable, boolean value) {
        if (value) {
            this.getUsage((AEFDBooleanVariable)variable).varToTrue = true;
        } else {
            this.getUsage((AEFDBooleanVariable)variable).varToFalse = true;
        }
    }

    private void reportVarRead(AEFDBooleanVariable variable) {
        this.getUsage((AEFDBooleanVariable)variable).varRead = true;
    }

    public void analyse(AEFDModel model) {
        this.model = model;
        this.usageMap.clear();
        this.diagnosticMap.clear();
        model.accept(this);
        for (VarDiagnostic diagnostic : VarDiagnostic.values()) {
            this.diagnosticMap.put(diagnostic, new LinkedList());
        }
        for (Map.Entry entry : this.usageMap.entrySet()) {
            this.diagnosticMap.get((Object)((Usage)entry.getValue()).getDiagnostic()).add((AEFDBooleanVariable)entry.getKey());
        }
    }

    public String getShortReport() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.usageMap.size() + " variables\n");
        for (VarDiagnostic diagnostic : VarDiagnostic.values()) {
            builder.append(this.diagnosticMap.get((Object)diagnostic).size() + "[" + (Object)((Object)diagnostic) + "]\n");
        }
        return builder.toString();
    }

    public String getOneLineReport(AEFDBooleanVariable variable, boolean includeDiagnostic) {
        StringBuilder result = new StringBuilder(variable.getName());
        result.append(" [").append(variable.getStringValue(true)).append("/").append(variable.getStringValue(false)).append("]");
        if (includeDiagnostic) {
            result.append(" ").append((Object)this.usageMap.get(variable).getDiagnostic());
        }
        return result.toString();
    }

    public String getReports(VarDiagnostic diagnostic) {
        StringBuilder result = new StringBuilder(diagnostic.toString());
        result.append("\n");
        for (AEFDBooleanVariable variable : this.diagnosticMap.get((Object)diagnostic)) {
            result.append("    ").append(this.getOneLineReport(variable, false)).append("\n");
        }
        return result.toString();
    }

    public String getAnomalyReports() {
        StringBuilder result = new StringBuilder();
        for (VarDiagnostic diagnostic : VarDiagnostic.values()) {
            if (diagnostic == VarDiagnostic.Normal) continue;
            result.append(this.getReports(diagnostic));
        }
        return result.toString();
    }

    public String getFullReport() {
        return this.getShortReport() + "\n\n" + this.getAnomalyReports();
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        transition.getCondition().accept(this);
        transition.getAction().accept(this);
    }

    @Override
    public void visitCondition(AEFDCondition condition) {
        condition.getBoolExp().accept(this);
    }

    @Override
    public void visitNot(AEFDBooleanExpression.Not not) {
        not.getExpression().accept(this);
    }

    @Override
    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept(this);
        or.getRhs().accept(this);
    }

    @Override
    public void visitAnd(AEFDBooleanExpression.And and) {
        and.getLhs().accept(this);
        and.getRhs().accept(this);
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        this.reportVarRead(variableEvaluation.getBooleanVariable());
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept(this);
        }
    }

    @Override
    public void visitAffectation(AEFDAction.Affectation affectation) {
        this.reportVarWrite(affectation.getVariable(), affectation.getNewValue());
    }

    public static enum VarDiagnostic {
        Normal,
        AlwaysTrue,
        AlwaysFalse,
        NeverWritten,
        NeverRead;

    }

    private static class Usage {
        public boolean varToTrue = false;
        public boolean varToFalse = false;
        public boolean varRead = false;

        private Usage() {
        }

        public boolean isAlwaysTrue() {
            return this.varToTrue && !this.varToFalse;
        }

        public boolean isAlwaysFalse() {
            return this.varToFalse && !this.varToTrue;
        }

        public boolean isNeverWritten() {
            return !this.varToTrue && !this.varToFalse;
        }

        public boolean isNeverRead() {
            return !this.varRead;
        }

        public VarDiagnostic getDiagnostic() {
            if (this.isNeverRead()) {
                return VarDiagnostic.NeverRead;
            }
            if (this.isNeverWritten()) {
                return VarDiagnostic.NeverWritten;
            }
            if (this.isAlwaysFalse()) {
                return VarDiagnostic.AlwaysFalse;
            }
            if (this.isAlwaysTrue()) {
                return VarDiagnostic.AlwaysTrue;
            }
            return VarDiagnostic.Normal;
        }
    }
}

