/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model.meta;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDPrefix;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.model.meta.SuffixPairs;
import fr.ensta.aefd.utils.ModelUtils;
import java.util.HashMap;
import java.util.Map;

public class ModelReferences
extends AEFDModelVisitor.Stub {
    private final AEFDModel model;
    private SuffixPairs suffixPairs = null;
    private final Map<String, AEFDAutomate> automateNameMap = new HashMap<String, AEFDAutomate>();
    private final Map<String, AEFDFunctionalEntity> identifierMap = new HashMap<String, AEFDFunctionalEntity>();
    private final Map<String, AEFDBooleanVariable> variableNameMap = new HashMap<String, AEFDBooleanVariable>();
    private final Map<AEFDFunctionalEntity, AEFDBooleanVariable> funcEntityToVarMap = new HashMap<AEFDFunctionalEntity, AEFDBooleanVariable>();
    private final Map<AEFDBooleanVariable, AEFDFunctionalEntity[]> varToFEMap = new HashMap<AEFDBooleanVariable, AEFDFunctionalEntity[]>();

    public ModelReferences(AEFDModel model) {
        this.model = model;
    }

    public void synchronizeUsed() {
        this.automateNameMap.clear();
        this.identifierMap.clear();
        this.variableNameMap.clear();
        this.model.accept(this);
        this.addMissingVariableLinks();
        this.addMissingFunctionalEntities();
    }

    public AEFDModel getModel() {
        return this.model;
    }

    public SuffixPairs getSuffixPairs() {
        if (this.suffixPairs == null) {
            return ModelUtils.DEFAULT_SUFFIX_PAIRS;
        }
        return this.suffixPairs;
    }

    public void setSuffixPairs(SuffixPairs suffixPairs) {
        this.suffixPairs = suffixPairs;
    }

    public AEFDAutomate getAutomate(String automateName) {
        return this.getAutomate(automateName, false);
    }

    public AEFDAutomate getAutomate(String automateName, boolean createIfAbsent) {
        AEFDAutomate result = this.automateNameMap.get(automateName);
        if (result == null && createIfAbsent) {
            result = new AEFDAutomate(automateName);
            this.automateNameMap.put(automateName, result);
            this.model.getAllAutomates().addLast(result);
        }
        return result;
    }

    public AEFDFunctionalEntity getFunctionalEntity(String dcoIdentifier, Integer parameter) {
        return this.getFunctionalEntity(dcoIdentifier, parameter, false);
    }

    public AEFDFunctionalEntity getFunctionalEntity(String dcoIdentifier, Integer parameter, boolean createIfAbsent) {
        String txtIdentifier = parameter != null ? dcoIdentifier + "(" + parameter + ")" : dcoIdentifier;
        return this.getFunctionalEntity(txtIdentifier, createIfAbsent);
    }

    public AEFDFunctionalEntity getFunctionalEntity(String txtIdentifier) {
        return this.getFunctionalEntity(txtIdentifier, false);
    }

    public AEFDFunctionalEntity getFunctionalEntity(String txtIdentifier, boolean createIfAbsent) {
        AEFDPrefix prefix;
        AEFDFunctionalEntity result = this.identifierMap.get(txtIdentifier);
        if (result != null || !createIfAbsent) {
            return result;
        }
        result = new AEFDFunctionalEntity();
        String prefixString = txtIdentifier.split("_")[0];
        try {
            prefix = AEFDPrefix.valueOf(prefixString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("issue with " + txtIdentifier);
        }
        result.setIdentifier(txtIdentifier);
        result.setPrefix(prefix);
        this.identifierMap.put(txtIdentifier, result);
        if (result.getPrefix().requiresSuffix()) {
            String suffix = this.getSuffixPairs().extractSuffix(txtIdentifier);
            result.setSuffix(suffix);
        }
        if (result.getPrefix().requiresParameter()) {
            int parameterIndex = txtIdentifier.indexOf(40) + 1;
            if (parameterIndex == 0) {
                throw new IllegalArgumentException("Identifier " + txtIdentifier + " requires a parameter.");
            }
            String parameterString = txtIdentifier.substring(parameterIndex, txtIdentifier.length() - 1);
            Integer parameter = Integer.valueOf(parameterString);
            result.setParameter(parameter);
        }
        this.model.getAllFunctionalEntity().add(result);
        return result;
    }

    private AEFDBooleanVariable getBooleanVariable(String variableName, String[] domain) {
        AEFDBooleanVariable result = this.variableNameMap.get(variableName);
        if (result != null) {
            if (domain == null || result.getStringValue(true).equals(domain[0]) && result.getStringValue(false).equals(domain[1])) {
                return result;
            }
            return this.getBooleanVariable(variableName + "_Alt", domain);
        }
        result = new AEFDBooleanVariable(variableName);
        if (domain != null) {
            result.setStringValue(true, domain[0]);
            result.setStringValue(false, domain[1]);
        }
        this.variableNameMap.put(variableName, result);
        this.model.addVariable(result);
        return result;
    }

    public AEFDBooleanVariable getBooleanVariable(AEFDFunctionalEntity functionalEntity) {
        AEFDPrefix prefix = functionalEntity.getPrefix();
        String identifier = functionalEntity.getIdentifier();
        if (prefix.requiresSuffix()) {
            String suffix = functionalEntity.getSuffix();
            String variableName = identifier.substring(0, identifier.length() - suffix.length() - 1);
            return this.getBooleanVariable(variableName, this.getSuffixPairs().getSuffixPair(suffix));
        }
        throw new IllegalArgumentException("Trying to create a variable from a functional entity without suffix (" + functionalEntity.getIdentifier() + ")");
    }

    public AEFDBooleanVariable getVariable(AEFDFunctionalEntity functionalEntity) {
        return this.funcEntityToVarMap.get(functionalEntity);
    }

    public AEFDFunctionalEntity[] getFunctionalEntities(AEFDBooleanVariable variable) {
        return this.varToFEMap.get(variable);
    }

    public void linkVariable(AEFDFunctionalEntity functionalEntity, AEFDBooleanVariable variable) {
        if (!functionalEntity.getPrefix().requiresSuffix()) {
            throw new UnsupportedOperationException("Cannot link a suffixless functional entity (" + functionalEntity.getIdentifier() + ")to a variable (" + variable.getName() + ")");
        }
        this.funcEntityToVarMap.put(functionalEntity, variable);
        if (variable.hasFunctionalEntities()) {
            AEFDFunctionalEntity[] functionalEntities = this.varToFEMap.get(variable);
            if (functionalEntities == null) {
                functionalEntities = new AEFDFunctionalEntity[2];
                this.varToFEMap.put(variable, functionalEntities);
            }
            int index = variable.getBooleanValue(functionalEntity.getSuffix()) ? 1 : 0;
            functionalEntities[index] = functionalEntity;
        }
    }

    public void addMissingVariableLinks() {
        for (AEFDFunctionalEntity functionalEntity : this.model.getAllFunctionalEntity()) {
            if (!functionalEntity.getPrefix().requiresSuffix() || this.getVariable(functionalEntity) != null) continue;
            this.linkVariable(functionalEntity, this.getBooleanVariable(functionalEntity));
        }
    }

    public void addMissingFunctionalEntities() {
        for (AEFDBooleanVariable variable : this.model.getAllVariables()) {
            String txtIdentifier;
            AEFDFunctionalEntity[] functionalEntities = this.getFunctionalEntities(variable);
            if (functionalEntities != null && functionalEntities[0] == null) {
                txtIdentifier = variable.getName().replaceAll("_Alt", "") + "_" + variable.getStringValue(false);
                functionalEntities[0] = this.getFunctionalEntity(txtIdentifier, true);
            }
            if (functionalEntities == null || functionalEntities[1] != null) continue;
            txtIdentifier = variable.getName().replaceAll("_Alt", "") + "_" + variable.getStringValue(true);
            functionalEntities[1] = this.getFunctionalEntity(txtIdentifier, true);
        }
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.automateNameMap.put(automate.getName(), automate);
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.automateNameMap.put(automate.getName(), automate);
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        transition.getEvent().accept(this);
        transition.getCondition().accept(this);
        transition.getAction().accept(this);
    }

    @Override
    public void visitEvent(AEFDEvent event) {
        event.getBoolExp().accept(this);
    }

    @Override
    public void visitCondition(AEFDCondition condition) {
        condition.getBoolExp().accept(this);
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept(this);
        }
    }

    @Override
    public void visitFunctionalEntity(AEFDFunctionalEntity functionalEntity) {
        this.identifierMap.put(functionalEntity.getIdentifier(), functionalEntity);
    }

    @Override
    public void visitVariable(AEFDBooleanVariable variable) {
        this.variableNameMap.put(variable.getName(), variable);
    }

    @Override
    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        trigger.getFunctionalEntity().accept(this);
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        variableEvaluation.getBooleanVariable().accept(this);
    }

    @Override
    public void visitNot(AEFDBooleanExpression.Not not) {
        not.getExpression().accept(this);
    }

    @Override
    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept(this);
        or.getRhs().accept(this);
    }

    @Override
    public void visitAnd(AEFDBooleanExpression.And and) {
        and.getLhs().accept(this);
        and.getRhs().accept(this);
    }

    @Override
    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        sendEvent.getFunctionalEntity().accept(this);
    }

    @Override
    public void visitAffectation(AEFDAction.Affectation affectation) {
        affectation.getVariable().accept(this);
    }
}

