/*
 * Decompiled with CFR 0.152.
 */
package plug.visualisation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import plug.statespace.IGraphAccess;

public class StateSpace2MTX {
    public static final StateSpace2MTX instance = new StateSpace2MTX();

    public static void toMTX(IGraphAccess graphView, String filepath) {
        try {
            instance.toMtx(graphView, filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toMtx(IGraphAccess graphView, String path) throws IOException {
        BufferedWriter br = new BufferedWriter(new FileWriter(path));
        this.toMtx(graphView, br);
    }

    public void toMtx(IGraphAccess graphView, Writer writer) throws IOException {
        writer.write("%%MatrixMarket matrix coordinate pattern general\n");
        writer.write(graphView.getVertexCount() + 1 + " " + (graphView.getVertexCount() + 1) + " " + (graphView.getEdgeCount() + graphView.getInitialVertices().size()) + "\n");
        HashMap<Object, Integer> idMap = new HashMap<Object, Integer>();
        for (Object vertex : graphView.getInitialVertices()) {
            writer.write("1 " + this.getID(vertex, idMap) + "\n");
        }
        for (Object source : graphView.getVertices()) {
            int sourceID = this.getID(source, idMap);
            for (Object target : graphView.fanout(source)) {
                writer.write(sourceID + " " + this.getID(target, idMap) + "\n");
            }
        }
        writer.close();
    }

    int getID(Object vertex, Map<Object, Integer> idMap) {
        Integer id = idMap.get(vertex);
        if (id == null) {
            id = idMap.size() + 2;
            idMap.put(vertex, id);
        }
        return id;
    }
}

