/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.Stack;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.BooleanLit;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Literal;

public class StaticEvaluator
extends ABCDVisitor.Stub {
    private static StaticEvaluator instance = new StaticEvaluator();
    private Stack<Expression> objectStack = new Stack();

    public static Literal evaluate(Expression exp) {
        return instance.eval(exp);
    }

    public Literal eval(Expression exp) {
        exp.accept(this);
        if (this.objectStack.isEmpty()) {
            return null;
        }
        return this.pop(Literal.class);
    }

    public <T> T peekObject(Class<T> type) {
        Expression node = this.objectStack.peek();
        return type.cast(node);
    }

    public <T> T pop(Class<T> type) {
        Expression node = this.objectStack.pop();
        return type.cast(node);
    }

    public Expression push(Expression node) {
        this.objectStack.push(node);
        return node;
    }

    @Override
    public void visitUnaryExp(UnaryExp exp) {
        exp.getOperand().accept(this);
        Literal lit = this.pop(Literal.class);
        Literal result = null;
        switch (exp.getOperator()) {
            case UMINUS: {
                if (lit instanceof IntegerLit) {
                    result = new IntegerLit();
                    result.setValue(-((IntegerLit)lit).getValue());
                    break;
                }
                System.err.println("Incorrect usage of unary minus on non integer expression");
                break;
            }
            case UNOT: {
                if (lit instanceof BooleanLit) {
                    if (lit instanceof TrueLit) {
                        result = new FalseLit();
                        break;
                    }
                    result = new TrueLit();
                    break;
                }
                System.err.println("Incorrect negation of non boolean expression");
            }
        }
        this.push(result);
    }

    @Override
    public void visitBinaryExp(BinaryExp exp) {
        boolean areInts;
        exp.getOperands(0).accept(this);
        Literal lhsl = this.pop(Literal.class);
        exp.getOperands(1).accept(this);
        Literal rhsl = this.pop(Literal.class);
        Literal result = null;
        boolean areBoolean = lhsl instanceof BooleanLit && rhsl instanceof BooleanLit;
        boolean bl = areInts = lhsl instanceof IntegerLit && rhsl instanceof IntegerLit;
        if (areInts) {
            int lhs = ((IntegerLit)lhsl).getValue();
            int rhs = ((IntegerLit)rhsl).getValue();
            switch (exp.getOperator()) {
                case BADD: {
                    result = new IntegerLit();
                    result.setValue(lhs + rhs);
                    break;
                }
                case BDIV: {
                    result = new IntegerLit();
                    result.setValue(lhs / rhs);
                    break;
                }
                case BEQ: {
                    result = lhs == rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BGE: {
                    result = lhs >= rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BGT: {
                    result = lhs > rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BLE: {
                    result = lhs <= rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BLT: {
                    result = lhs < rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BMINUS: {
                    result = new IntegerLit();
                    result.setValue(lhs - rhs);
                    break;
                }
                case BMOD: {
                    result = new IntegerLit();
                    result.setValue(lhs % rhs);
                    break;
                }
                case BMUL: {
                    result = new IntegerLit();
                    result.setValue(lhs * rhs);
                    break;
                }
                case BNE: {
                    result = lhs != rhs ? new TrueLit() : new FalseLit();
                    break;
                }
            }
        } else if (areBoolean) {
            boolean lhs = lhsl instanceof TrueLit;
            boolean rhs = rhsl instanceof TrueLit;
            switch (exp.getOperator()) {
                case BAND: {
                    result = lhs && rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BEQ: {
                    result = lhs == rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BNAND: {
                    result = !lhs || !rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BNE: {
                    result = lhs != rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BNOR: {
                    result = !lhs && !rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BOR: {
                    result = lhs || rhs ? new TrueLit() : new FalseLit();
                    break;
                }
                case BXOR: {
                    result = !(!lhs && !rhs || lhs && rhs) ? new TrueLit() : new FalseLit();
                    break;
                }
            }
        } else {
            System.err.println("Incorrect binary expression");
        }
        this.push(result);
    }

    @Override
    public void visitIndexedExp(IndexedExp exp) {
        exp.getIndex().accept(this);
        Literal idx = this.pop(Literal.class);
        exp.getPrefix().accept(this);
        Literal prefix = this.pop(Literal.class);
        if (idx == null || prefix == null || !(idx instanceof IntegerLit) || !(prefix instanceof ArrayLit)) {
            this.push(null);
            return;
        }
        Expression idxExp = ((ArrayLit)prefix).getValue(((IntegerLit)idx).getValue());
        idxExp.accept(this);
    }

    @Override
    public void visitSelectedExp(SelectedExp exp) {
        exp.getPrefix().accept(this);
        Literal prefix = this.pop(Literal.class);
        if (prefix == null || !(prefix instanceof RecordLit)) {
            this.push(null);
            return;
        }
        boolean found = false;
        for (FieldLiteral fl : ((RecordLit)prefix).getValueList()) {
            if (!fl.getName().equals(exp.getSelector())) continue;
            fl.getValue().accept(this);
            found = true;
            break;
        }
        if (!found) {
            this.push(null);
        }
    }

    @Override
    public void visitReference(Reference exp) {
        exp.getRef().accept(this);
    }

    @Override
    public void visitConstantDecl(ConstantDecl d) {
        d.getValue().accept(this);
    }

    @Override
    public void visitArrayLit(ArrayLit exp) {
        ArrayLit result = new ArrayLit();
        for (Expression e : exp.getValueList()) {
            e.accept(this);
            Literal item = this.pop(Literal.class);
            if (item == null) {
                this.push(null);
                return;
            }
            result.addValue(item);
        }
        this.push(result);
    }

    @Override
    public void visitRecordLit(RecordLit exp) {
        RecordLit result = new RecordLit();
        for (FieldLiteral f : exp.getValueList()) {
            f.accept(this);
            FieldLiteral item = this.pop(FieldLiteral.class);
            if (item == null) {
                this.push(null);
                return;
            }
            result.addValue(item);
        }
        this.push(result);
    }

    @Override
    public void visitFieldLiteral(FieldLiteral f) {
        f.getValue().accept(this);
        Literal v = this.pop(Literal.class);
        if (v == null) {
            this.push(null);
            return;
        }
        FieldLiteral result = new FieldLiteral();
        result.setValue(v);
        result.setName(f.getName());
        this.push(result);
    }

    @Override
    public void visitIntegerLit(IntegerLit l) {
        this.push(l);
    }

    @Override
    public void visitTrueLit(TrueLit l) {
        this.push(l);
    }

    @Override
    public void visitFalseLit(FalseLit l) {
        this.push(l);
    }
}

