/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.listener;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import obp.explorer.runtime.core.Transition;
import obp.simulation.component.Console;
import obp.simulation.component.SelectPrevious;
import obp.simulation.component.SimulationView;
import obp.simulation.component.TransitionPanel;
import obp.simulation.controler.SimulationControler;

public class ButtonListener
implements ActionListener {
    private Console console;
    private SimulationView simulationView;
    private TransitionPanel transitionPanel;
    private SimulationControler simulationControler;

    public ButtonListener(SimulationView simulationView, SimulationControler simulationControler) {
        this.simulationView = simulationView;
        this.console = simulationView.getConsole();
        this.transitionPanel = simulationView.getTransitionPanel();
        this.simulationControler = simulationControler;
        this.checkObserver(simulationControler, simulationView);
    }

    public void checkObserver(SimulationControler simulationControler, SimulationView simulationView) {
        if (simulationControler.getObsViewerList() == null) {
            simulationView.getMenu().desableObserverControl();
        } else if (simulationControler.getObsViewerList().size() == 0) {
            simulationView.getMenu().desableObserverControl();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
        if (e.getActionCommand().matches("close")) {
            System.out.println("close");
            this.simulationView.dispose();
            this.simulationView.getGraphicsPanel().exit();
            this.simulationControler.exit();
        }
        if (e.getActionCommand().matches("displayTrace")) {
            System.out.println("Open trace dialog");
            this.simulationView.openTraceDialog();
        }
        if (e.getActionCommand().matches("clearConsole")) {
            this.console.clear();
        }
        if (e.getActionCommand().matches("restart")) {
            this.console.addText("Restart");
            this.simulationControler.restart();
        }
        if (e.getActionCommand().matches("previous")) {
            System.out.println(this.simulationControler.getNbConfig());
            if (this.simulationControler.getPreviousList().size() > 1) {
                SelectPrevious dialog = new SelectPrevious((Frame)this.simulationView, this.simulationControler);
                dialog.setVisible(true);
            } else {
                this.simulationControler.getPreviousConfig();
            }
        }
        if (e.getActionCommand().matches("next")) {
            if (this.transitionPanel.getTransitionList().getSelectedValue() != null) {
                Transition toFire = this.transitionPanel.getTransitionList().getSelectedValue();
                this.simulationControler.next(toFire);
            } else {
                this.console.addTextError("Aucun message selectionn !");
            }
        }
        if (e.getActionCommand().matches("nextRandom")) {
            this.simulationControler.nextRandom();
        }
        if (e.getActionCommand().matches("start")) {
            System.out.println("start");
            this.simulationView.getToolBar().startAction();
            this.simulationControler.startAutoMode();
        }
        if (e.getActionCommand().matches("pause")) {
            this.simulationView.getToolBar().pauseAction();
            this.simulationControler.pauseAutoMode();
        }
        if (e.getActionCommand().matches("stop")) {
            this.simulationView.getToolBar().stopAction();
            this.simulationControler.stopAutoMode();
        }
        if (e.getActionCommand().matches("load")) {
            this.console.addTextError("Not implemented yet");
        }
        if (e.getActionCommand().matches("save")) {
            this.console.addTextError("Not implemented yet");
        }
        if (e.getActionCommand().matches("exportToDot")) {
            this.dotExport();
        }
        if (e.getActionCommand().matches("exportToSvg")) {
            this.svgExport();
        }
        if (e.getActionCommand().matches("displayObservers")) {
            this.simulationControler.openAllObsViewer();
        }
        if (e.getActionCommand().matches("hideObservers")) {
            this.simulationControler.closeAllObsViewer();
        }
    }

    public void load() {
        File repertoireCourant = null;
        try {
            repertoireCourant = new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            this.console.addTextError(e.getMessage());
        }
        JFileChooser dialogue = new JFileChooser(repertoireCourant);
        dialogue.showDialog(this.simulationView, "Load ...");
        if (dialogue.getSelectedFile() != null) {
            this.console.addText("loading: " + dialogue.getSelectedFile().toString());
        }
    }

    public void save() {
        int dialogResult = 0;
        File repertoireCourant = null;
        File saveOn = null;
        try {
            repertoireCourant = new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            this.console.addTextError(e.getMessage());
        }
        JFileChooser dialogue = new JFileChooser(repertoireCourant);
        dialogue.showDialog(this.simulationView, "Save ...");
        if (dialogue.getSelectedFile() != null) {
            saveOn = dialogue.getSelectedFile();
            if (!saveOn.exists()) {
                try {
                    saveOn.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                dialogResult = JOptionPane.showConfirmDialog(this.simulationView, "Un fichier de mme nom existe dj  cet emplacement.\n Voulez-vous vraiment le remplacer ? ", "Remplacer le fichier", 0);
            }
            if (dialogResult != 1) {
                this.console.addText("save at: " + saveOn.getPath());
            }
        }
    }

    public void dotExport() {
        int dialogResult = 0;
        File exportOn = null;
        JFileChooser dialogue = new JFileChooser();
        dialogue.showDialog(this.simulationView, "Export ...");
        if (dialogue.getSelectedFile() != null) {
            exportOn = dialogue.getSelectedFile();
            if (!exportOn.getName().contains(".dot")) {
                String path = exportOn.getPath();
                exportOn = new File(path + ".dot");
            }
            if (!exportOn.exists()) {
                try {
                    exportOn.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                dialogResult = JOptionPane.showConfirmDialog(this.simulationView, "Un fichier de mme nom existe dj  cet emplacement.\n Voulez-vous vraiment le remplacer ? ", "Remplacer le fichier", 0);
            }
            if (dialogResult != 1) {
                if (ButtonListener.copier(this.simulationControler.getGraphFile(), exportOn)) {
                    this.console.addText("Graph export location : " + exportOn.getPath());
                } else {
                    this.console.addTextError("Erreur export");
                }
            }
        }
    }

    public void svgExport() {
        int dialogResult = 0;
        File exportOn = null;
        JFileChooser dialogue = new JFileChooser();
        dialogue.showDialog(this.simulationView, "Export ...");
        if (dialogue.getSelectedFile() != null) {
            exportOn = dialogue.getSelectedFile();
            if (!exportOn.getName().contains(".svg")) {
                String path = exportOn.getPath();
                exportOn = new File(path + ".svg");
            }
            if (!exportOn.exists()) {
                try {
                    exportOn.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                dialogResult = JOptionPane.showConfirmDialog(this.simulationView, "Un fichier de mme nom existe dj  cet emplacement.\n Voulez-vous vraiment le remplacer ? ", "Remplacer le fichier", 0);
            }
            if (dialogResult != 1) {
                this.simulationControler.svgExport(exportOn);
                this.console.addText("Graph export location : " + exportOn.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copier(File source, File destination) {
        boolean resultat = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            int nbLecture;
            destination.createNewFile();
            sourceFile = new FileInputStream(source);
            destinationFile = new FileOutputStream(destination);
            byte[] buffer = new byte[524288];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, nbLecture);
            }
            resultat = true;
        }
        catch (FileNotFoundException f) {
            System.err.println("File not found");
        }
        catch (IOException e) {
            System.err.println("IOException");
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception f) {}
            try {
                destinationFile.close();
            }
            catch (Exception f) {}
        }
        return resultat;
    }
}

