/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime;

import java.util.List;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Channel;
import org.xid.basics.serializer.Boost;

public abstract class Behavior
implements Component {
    public final short id;
    public final String name;

    public Behavior(String name, SymbolsTable symbols) {
        this.id = symbols.getBehaviorId(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public short getId() {
        return this.id;
    }

    public int getStateId(String name) {
        throw new IllegalArgumentException("State '" + name + "' doesn't exist in behavior '" + this.name + "'.");
    }

    public String getStateName(short id) {
        return null;
    }

    @Override
    public void collectChannels(List<Channel> result) {
    }

    public abstract BehaviorConfiguration createInitialConfiguration(Configuration var1);

    public abstract BehaviorConfiguration readConfiguration(Boost var1);

    public abstract void writeConfiguration(Boost var1, BehaviorConfiguration var2);

    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return behaviorConfiguration.toString();
    }

    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return behaviorConfiguration.toString();
    }

    public void invariant(Configuration configuration, ExplorationContext context) {
    }

    public void link(ExplorationContext context, SymbolsTable symbols) {
    }
}

