/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import java.util.LinkedList;

public class AEFDRuntimeGuardEvaluator
extends AEFDModelVisitor.Stub {
    private final AEFDRuntimeInfos infos;
    private final LinkedList<Boolean> stack;
    private AEFDRuntimeSystemState currentSource;

    public AEFDRuntimeGuardEvaluator(AEFDRuntimeInfos infos) {
        this.infos = infos;
        this.stack = new LinkedList();
    }

    public boolean evaluateGuard(AEFDRuntimeSystemState source, AEFDTransition transition) {
        this.currentSource = source;
        this.stack.clear();
        transition.accept((AEFDModelVisitor)this);
        if (this.stack.size() != 1) {
            throw new IllegalStateException("Stack should have size 1 after visiting guard");
        }
        return this.stack.removeFirst();
    }

    public void visitTransition(AEFDTransition transition) {
        transition.getCondition().accept((AEFDModelVisitor)this);
    }

    public void visitCondition(AEFDCondition condition) {
        condition.getBoolExp().accept((AEFDBooleanExpression.Visitor)this);
    }

    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        throw new IllegalStateException("Trigger found in a condition");
    }

    public void visitConstant(AEFDBooleanExpression.Constant constant) {
        this.stack.push(constant.getValue());
    }

    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        AEFDBooleanVariable variable = variableEvaluation.getBooleanVariable();
        int variableIndex = this.infos.getVariableIndex(variable);
        boolean variableValue = this.currentSource.getVariables()[variableIndex];
        this.stack.push(variableValue == variableEvaluation.getExpectedValue());
    }

    public void visitNot(AEFDBooleanExpression.Not not) {
        not.getExpression().accept((AEFDBooleanExpression.Visitor)this);
        this.stack.push(this.stack.pop() == false);
    }

    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept((AEFDBooleanExpression.Visitor)this);
        if (this.stack.pop().booleanValue()) {
            this.stack.push(true);
        } else {
            or.getRhs().accept((AEFDBooleanExpression.Visitor)this);
        }
    }

    public void visitAnd(AEFDBooleanExpression.And and) {
        and.getLhs().accept((AEFDBooleanExpression.Visitor)this);
        if (!this.stack.pop().booleanValue()) {
            this.stack.push(false);
        } else {
            and.getRhs().accept((AEFDBooleanExpression.Visitor)this);
        }
    }
}

