/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntime;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import java.util.function.Predicate;
import plug.core.IAtomicPropositionsEvaluator;

public class AEFDAtomicPropositionEvaluator
implements IAtomicPropositionsEvaluator<AEFDRuntimeSystemState, AEFDTransition> {
    static final String WARNING = "warning";
    static final String REJECT = "reject";
    String[] atomicPropositions;
    Predicate<AEFDRuntimeSystemState>[] atomicPropositionEvaluator;
    AEFDRuntime runtime;

    public AEFDAtomicPropositionEvaluator(AEFDRuntime runtime) {
        this.runtime = runtime;
    }

    public int[] registerAtomicPropositions(String[] atomicProps) throws Exception {
        this.atomicPropositions = new String[atomicProps.length];
        this.atomicPropositionEvaluator = new Predicate[atomicProps.length];
        int[] idx = new int[atomicProps.length];
        for (int i = 0; i < atomicProps.length; ++i) {
            this.atomicPropositions[i] = atomicProps[i];
            if (atomicProps[i].equals(WARNING)) {
                this.atomicPropositionEvaluator[i] = AEFDRuntimeSystemState::isWarningState;
            } else if (atomicProps[i].equals(REJECT)) {
                this.atomicPropositionEvaluator[i] = AEFDRuntimeSystemState::isRejectState;
            } else {
                int indexAt = atomicProps[i].indexOf(64);
                if (atomicProps[i].indexOf(64) != -1) {
                    String automatonName = atomicProps[i].substring(0, indexAt);
                    AEFDAutomate automata = this.runtime.references.getAutomate(automatonName);
                    if (automata == null) {
                        throw new RuntimeException("could not find the automaton named " + automatonName);
                    }
                    String state = atomicProps[i].substring(indexAt + 1, atomicProps[i].length());
                    int automatonIndex = this.runtime.infos.getAutomateIndex(automata);
                    int value = this.runtime.infos.getAutomateStateIndex(automatonIndex, state);
                    this.atomicPropositionEvaluator[i] = c -> c.getAutomatesStates()[automatonIndex] == value;
                } else {
                    AEFDFunctionalEntity entity = this.runtime.references.getFunctionalEntity(atomicProps[i]);
                    if (entity == null) {
                        throw new RuntimeException("could not find the entity named " + atomicProps[i]);
                    }
                    AEFDBooleanVariable variable = this.runtime.references.getBooleanVariable(entity);
                    if (entity == null) {
                        throw new RuntimeException("could not find the variable named " + atomicProps[i]);
                    }
                    int index = this.runtime.infos.getVariableIndex(variable);
                    this.atomicPropositionEvaluator[i] = c -> c.getVariables()[index];
                }
            }
            idx[i] = i;
        }
        return idx;
    }

    public boolean[] getAtomicPropositionValuations(AEFDRuntimeSystemState configuration) {
        boolean[] result = new boolean[this.atomicPropositionEvaluator.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.atomicPropositionEvaluator[i].test(configuration);
        }
        return result;
    }
}

