/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.basic;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.util.FetchTransitionReceivedEvents;
import fr.ensta.aefd.toolbox.tools.analysis.util.FetchTransitionWrittenVariables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WrittenVariablesAnalysis
extends AEFDModelVisitor.Stub {
    private final Set<AEFDBooleanVariable> writtenVariables = new HashSet<AEFDBooleanVariable>();
    private final Map<AEFDAutomate, Set<AEFDBooleanVariable>> globalWrittenVariables = new HashMap<AEFDAutomate, Set<AEFDBooleanVariable>>();
    private final Map<AEFDBooleanVariable, Set<AEFDAutomate>> globalWriters = new HashMap<AEFDBooleanVariable, Set<AEFDAutomate>>();
    private final Map<AEFDFunctionalEntity, Map<AEFDAutomate, Set<AEFDBooleanVariable>>> eventSpecificWrittenVariables = new HashMap<AEFDFunctionalEntity, Map<AEFDAutomate, Set<AEFDBooleanVariable>>>();
    private final Map<AEFDFunctionalEntity, Map<AEFDBooleanVariable, Set<AEFDAutomate>>> eventSpecificWriters = new HashMap<AEFDFunctionalEntity, Map<AEFDBooleanVariable, Set<AEFDAutomate>>>();
    private final FetchTransitionReceivedEvents eventFetcher = new FetchTransitionReceivedEvents();
    private final FetchTransitionWrittenVariables variableFetcher = new FetchTransitionWrittenVariables();
    private AEFDAutomate currentAutomate;

    private void initialize(AEFDModel model) {
        this.writtenVariables.clear();
        this.globalWrittenVariables.clear();
        this.globalWriters.clear();
        this.eventSpecificWrittenVariables.clear();
        this.eventSpecificWriters.clear();
        for (AEFDFunctionalEntity event : model.getAllFunctionalEntity()) {
            HashMap localMap = new HashMap();
            for (AEFDAutomate automate : model.getAllAutomates()) {
                localMap.put(automate, new HashSet());
            }
            this.eventSpecificWrittenVariables.put(event, localMap);
            HashMap reverseLocalMap = new HashMap();
            for (AEFDBooleanVariable variable : model.getAllVariables()) {
                reverseLocalMap.put(variable, new HashSet());
            }
            this.eventSpecificWriters.put(event, reverseLocalMap);
        }
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.globalWrittenVariables.put(automate, new HashSet());
        }
        for (AEFDBooleanVariable variable : model.getAllVariables()) {
            this.globalWriters.put(variable, new HashSet());
        }
    }

    public void analyze(AEFDModel model) {
        this.initialize(model);
        model.accept(this);
    }

    public Set<AEFDBooleanVariable> getWrittenVariables() {
        return this.writtenVariables;
    }

    public Set<AEFDBooleanVariable> getWrittenVariables(AEFDAutomate automate) {
        return this.globalWrittenVariables.get(automate);
    }

    public Set<AEFDBooleanVariable> getWrittenVariablesOn(AEFDAutomate automate, AEFDFunctionalEntity event) {
        return this.eventSpecificWrittenVariables.get(event).get(automate);
    }

    public Set<AEFDAutomate> getWriters(AEFDBooleanVariable variable) {
        return this.globalWriters.get(variable);
    }

    public Set<AEFDAutomate> getWritersOn(AEFDBooleanVariable variable, AEFDFunctionalEntity event) {
        return this.eventSpecificWriters.get(event).get(variable);
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.currentAutomate = automate;
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        for (AEFDBooleanVariable variable : this.variableFetcher.getWrittenVariables(transition)) {
            this.writtenVariables.add(variable);
            this.globalWrittenVariables.get(this.currentAutomate).add(variable);
            this.globalWriters.get(variable).add(this.currentAutomate);
            for (AEFDFunctionalEntity event : this.eventFetcher.getReceivedEvents(transition)) {
                this.eventSpecificWrittenVariables.get(event).get(this.currentAutomate).add(variable);
                this.eventSpecificWriters.get(event).get(variable).add(this.currentAutomate);
            }
        }
    }
}

