/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model;

import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.HashSet;
import java.util.Set;

public class AEFDAutomate
implements AEFDModelObject {
    private final String name;
    private final Set<AEFDTransition> transitionSet;
    private final Set<String> placeSet;
    private int numberOfTokens;
    private String initialPlace = null;

    public AEFDAutomate(String name) {
        this.name = name;
        this.transitionSet = new HashSet<AEFDTransition>();
        this.placeSet = new HashSet<String>();
        this.numberOfTokens = 1;
    }

    public String getName() {
        return this.name;
    }

    public boolean addTransition(AEFDTransition transition) {
        if (this.transitionSet.add(transition)) {
            this.placeSet.add(transition.getPlaceSource());
            this.placeSet.add(transition.getPlaceTarget());
            return true;
        }
        return false;
    }

    public boolean removeTransition(AEFDTransition transition) {
        return this.transitionSet.remove(transition);
    }

    public int getNumberOfTokens() {
        return this.numberOfTokens;
    }

    public void setNumberOfTokens(int numberOfTokens) {
        this.numberOfTokens = numberOfTokens;
    }

    public String getInitialPlace() {
        return this.initialPlace;
    }

    public void setInitialPlace(String initialPlace) {
        this.initialPlace = initialPlace;
    }

    public Set<AEFDTransition> getTransitionSet() {
        return this.transitionSet;
    }

    public Set<String> getPlaceSet() {
        return this.placeSet;
    }

    @Override
    public void accept(AEFDModelVisitor visitor) {
        visitor.visitAutomate(this);
    }
}

