/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.DeferredEvent;

public class Transition
implements Statement {
    private State from;
    private final List<DeferredEvent> deferredEventsList = new ArrayList<DeferredEvent>();
    private Block behavior;
    private ProcessDecl parent;

    public State getFrom() {
        return this.from;
    }

    public void setFrom(State newValue) {
        if (this.from == null ? newValue != null : !this.from.equals(newValue)) {
            this.from = newValue;
        }
    }

    public List<DeferredEvent> getDeferredEventsList() {
        return Collections.unmodifiableList(this.deferredEventsList);
    }

    public int getDeferredEventsCount() {
        return this.deferredEventsList.size();
    }

    public DeferredEvent getDeferredEvents(int index) {
        if (index < 0 || index >= this.getDeferredEventsCount()) {
            return null;
        }
        return this.deferredEventsList.get(index);
    }

    public void addDeferredEvents(DeferredEvent newValue) {
        this.addDeferredEvents(this.getDeferredEventsCount(), newValue);
    }

    public void addDeferredEvents(int index, DeferredEvent newValue) {
        this.deferredEventsList.add(index, newValue);
    }

    public DeferredEvent setDeferredEvents(int index, DeferredEvent newValue) {
        return this.deferredEventsList.set(index, newValue);
    }

    public void addAllDeferredEvents(Collection<DeferredEvent> toAddList) {
        for (DeferredEvent newValue : toAddList) {
            this.addDeferredEvents(this.getDeferredEventsCount(), newValue);
        }
    }

    public void removeDeferredEvents(DeferredEvent value) {
        int index = this.deferredEventsList.indexOf(value);
        if (index >= 0) {
            this.removeDeferredEvents(index);
        }
    }

    public void removeDeferredEvents(int index) {
        this.deferredEventsList.remove(index);
    }

    public Block getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Block newValue) {
        if (this.behavior == null ? newValue != null : !this.behavior.equals(newValue)) {
            this.behavior = newValue;
        }
    }

    public ProcessDecl getParent() {
        return this.parent;
    }

    public void setParent(ProcessDecl newValue) {
        if (this.parent == null ? newValue != null : !this.parent.equals(newValue)) {
            this.parent = newValue;
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitTransition(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof Transition)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((Transition)that, cache);
    }

    protected boolean equalsFeatures(Transition that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        if (this.deferredEventsList != null) {
            if (that.deferredEventsList == null) {
                return false;
            }
            l1size = this.deferredEventsList.size();
            if (l1size != (l2size = that.deferredEventsList.size())) {
                return false;
            }
            for (int i = 0; i < l1size; ++i) {
                if (this.deferredEventsList.get(i).equalsCached(that.deferredEventsList.get(i), cache)) continue;
                return false;
            }
        }
        return this.behavior.equalsCached(that.behavior, cache);
    }
}

